package com.jhscale.network.entity.food.res;

import com.jhscale.common.utils.Base64Utils;
import com.jhscale.common.utils.JSONUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.HashMap;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description: 上海主副食品登录token 解析信息
 * @date 2023/7/20 19:48
 */
@NoArgsConstructor
@ApiModel
@Data
public class UploadFoodTokenInfo implements Serializable {
    //token过期时间 毫秒 默认25分钟
    public static final long TOKEN_EXPIRE =1000* 50;

    /*
    {
    "msg": "操作成功",
    "code": 200,
    "token":” eyJhbGciOiJIUzI1NiJ9.eyJqdGkiOiI4ODgiLCJzdWIiOiLlsI_nmb0iLCJpYXQiOjE1MjM0MTY1NjksImV4cCI6MTUyMzQxNjYyOX0.Tk91b6mvyjpKcldkic8DgXz0zsPFFnRgTgkgcAsa9cc”
    }

    JWT格式token, 带有过期时间（exp）。
    示例中，Token 通过句点分为三个部分，分别是 header（红色）, payload（紫色） 以及signature （蓝色）。
    Header是如下信息的BASE64 编码：
    {"alg": "HS256"}

    Payload 是如下信息的 BASE64 编码：
    {
      "jti": "888",
      "sub": "小白",
      "iat": 1523416569,
      "exp": 1523416629
    }

    其中exp 字段为 token 过期时间
    */

    @ApiModelProperty(notes = "原始token", example = "eyJhbGciOiJIUzI1NiJ9.eyJqdGkiOiI4ODgiLCJzdWIiOiLlsI_nmb0iLCJpYXQiOjE1MjM0MTY1NjksImV4cCI6MTUyMzQxNjYyOX0.Tk91b6mvyjpKcldkic8DgXz0zsPFFnRgTgkgcAsa9cc")
    private String original;


    @ApiModelProperty(notes = "加密方式", example = "HS256")
    private String alg;

    @ApiModelProperty(notes = "login_user_key", example = "")
    private String login_user_key;
    //    @ApiModelProperty(notes = "jti", example = "888")
//    private String jti;
//    @ApiModelProperty(notes = "sub", example = "小白")
//    private String sub;
//    @ApiModelProperty(notes = "iat", example = "1523416629")
//    private Long iat;
    @ApiModelProperty(notes = "过期时间", example = "1523416629")
    private Long exp;

//    public static void main(String[] args) {
//        String token = "eyJhbGciOiJIUzUxMiJ9.eyJsb2dpbl91c2VyX2tleSI6IjhhNWM1ZmM5LWFjNmUtNGY1NS05NDQzLThkODMwMmM3Yzc1ZSJ9.mdEryjYYE7e5aHc7sDEwh2q1YlW9sM77DiDgJsBbz3hlTcbMq-9tffktd1DUgtWUfbFqWMb9MUZbqzNPc3WvVw";
//        parseToken(token);
//    }

    /**
     * @description: 解析token
     **/
    public static UploadFoodTokenInfo parseToken(String token) {
        UploadFoodTokenInfo reuslt = new UploadFoodTokenInfo();
        reuslt.setOriginal(token);

        String[] split = token.split("\\.");

        String methodBefore = split[0];
        String methodAfter = Base64Utils.decodeData(methodBefore);
        HashMap methodGet = JSONUtils.jsonToObject(methodAfter, HashMap.class);
        reuslt.setAlg((String) methodGet.get("alg"));

        String infoBefore = split[1];
        String infoAfter = Base64Utils.decodeData(infoBefore);
        HashMap infoGet = JSONUtils.jsonToObject(infoAfter, HashMap.class);
        String login_user_key = (String) infoGet.get("login_user_key");
        reuslt.setLogin_user_key(login_user_key);
        reuslt.setExp(System.currentTimeMillis() + TOKEN_EXPIRE);
        return reuslt;
    }
//    /**
//     * @description: 解析token
//     **/
//    public static UploadFoodTokenInfo parseToken(String token) {
//        UploadFoodTokenInfo reuslt = new UploadFoodTokenInfo();
//        reuslt.setOriginal(token);
//
//        String[] split = token.split("\\.");
//
////        String headerBefore = split[0];
////        String headerAfter = Base64Utils.decodeData(headerBefore);
////        reuslt.setHeader(headerAfter);
//
//        String methodBefore = split[0];
//        String methodAfter = Base64Utils.decodeData(methodBefore);
//        HashMap methodGet = JSONUtils.jsonToObject(methodAfter, HashMap.class);
//        reuslt.setAlg((String) methodGet.get("alg"));
//
//        String infoBefore = split[1];
//        String infoAfter = Base64Utils.decodeData(infoBefore);
//        HashMap infoGet = JSONUtils.jsonToObject(infoAfter, HashMap.class);
//        reuslt.setJti((String) infoGet.get("jti"));
//        reuslt.setSub((String) infoGet.get("sub"));
//        reuslt.setIat((Long) infoGet.get("iat"));
//        reuslt.setExp((Long) infoGet.get("exp"));
//
//        return reuslt;
//    }

    /**
     * @description: token是否过期
     **/
    public boolean expire() {
        return exp.compareTo(System.currentTimeMillis() ) < 0;
    }

}
