package com.jhscale.network.entity.sh;

import com.jhscale.common.model.simple.JSONModel;
import com.ysscale.framework.utils.JSONUtils;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Objects;

/**
 * @author lie_w
 * @title: SHCertResponse
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1216:34
 */
@Data
@ApiModel("证件照响应信息")
public class SHCertInnerResponse extends JSONModel {

    private String errorCode;

    private Object data;

    private String logid;

    private String message;

    /**
     * @description: 响应对应信息
     **/
    public <T> T toBody(Class<T> clazz) {
        return this.errorCode != null && "0".equals(this.errorCode) && Objects.nonNull(data) ? JSONUtils.beanToBean(this.data, clazz) : null;
    }
}
