package com.jhscale.network.entity.sh;

import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.network.utils.MS2Helper;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: SHCertRequest
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1217:45
 */
@Data
@ApiModel("上海证件请求")
public class SHCertRequest extends JRequest {

    // 业务编号
    private String tradeCode;

    // 证照业务token
    private String tradeToken;

    // 内容
    private String message;

    // 备注
    private String remark = "营业执照";

    // 业务流水号
    private String businessNo;

    // 应用场景或用途
    private String appBusiness = "营业执照";

    // 应用业务唯一编号
    private String appTaskId;

    // 应用商户名称
    private String appMerchant;

    // 应用实际操作人姓名
    private String appOperator = "JHScale";

    /**
     * @description: 证照业务token
     **/
    public SHCertRequest defaultTradeToken(String account, String password) {
        this.tradeToken = MS2Helper.getTradeToken(account, password);
        return this;
    }

    /**
     * @description: 添加参数
     **/
    public SHCertRequest addParam(String tradeCode, String taskId, String merchant, String operator) {
        this.tradeCode = tradeCode;
        this.businessNo = String.valueOf(System.currentTimeMillis());
        this.appTaskId = StringUtils.isNotBlank(taskId) ? taskId : this.businessNo;
        this.appMerchant = StringUtils.isNotBlank(merchant) ? merchant : "JHScale";
        this.appOperator = StringUtils.isNotBlank(operator) ? operator : "JHScale";
        return this;
    }

    /**
     * @description: 添加参数
     **/
    public SHCertRequest addMessage(JSONModel model) {
        this.message = model.toJSON();
        return this;
    }
}
