package com.jhscale.network.entity.sh;

import com.jhscale.common.model.simple.JSONModel;
import com.ysscale.framework.utils.JSONUtils;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.util.Objects;

/**
 * @author lie_w
 * @title: SHCertResponse
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1216:34
 */
@Data
@ApiModel("证件照响应信息")
public class SHCertResponse extends JSONModel {

    private Integer status;

    private Object result;

    /**
     * @description: 响应对应信息
     **/
    public <T> T toBody(Class<T> clazz) {
        return this.status == 200 && Objects.nonNull(result) ? JSONUtils.beanToBean(this.result, clazz) : null;
    }

    /**
     * @description: 业务响应
     **/
    public <T> T toInnerBody(Class<T> clazz) {
        SHCertInnerResponse shCertInnerResponse = this.status == 200 && Objects.nonNull(this.result)
                ?
                JSONUtils.jsonToPojo(((String) this.result).trim(), SHCertInnerResponse.class) : null;
        return Objects.nonNull(shCertInnerResponse) ? shCertInnerResponse.toBody(clazz) : null;
    }
}
