package com.jhscale.network.entity.sh;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lie_w
 * @title: SHCertToken
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1216:21
 */
@Data
@ApiModel("证件照获取Token")
@NoArgsConstructor
@AllArgsConstructor
public class SHCertTokenRequest extends JSONModel {

    @ApiModelProperty(value = "用户身份", name = "appId", required = true)
    private String appId;

    @ApiModelProperty(value = "用户密码", name = "appSecret", required = true)
    private String appSecret;

    @ApiModelProperty(value = "sdl（固定值）", name = "client")
    private String client;

    public SHCertTokenRequest(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }
}
