package com.jhscale.network.entity.sh;

import com.jhscale.common.model.http.JRequest;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author lie_w
 * @title: SHIDObtainRequest
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1216:00
 */
@Data
@ApiModel("上海证件照获取请求")
public class SHIDObtainRequest extends JRequest {

    @ApiModelProperty(value = "随申办亮证QR", name = "qr", required = true)
    private String qr;

    @ApiModelProperty(value = "证件照数量（默认全部） 1,2,4-n2表示把第1、第2页和第4到倒数第2页", name = "number")
    private String number;

    @ApiModelProperty(value = "获取方式 0|Null 默认 缩略图 1-BASE64", name = "type")
    private Integer type;

    @ApiModelProperty(value = "获取方式 == 默认 生效 打开方式 0|Null 默认 在线打开 1-弹出下载", name = "open")
    private Integer open;

    @ApiModelProperty(value = "水印 不传默认（-）", name = "open")
    private String watermark;

    @ApiModelProperty(value = "获取证件照 帐号（不填 默认）", name = "account")
    private String account;

    @ApiModelProperty(value = "获取证件照 密码（不填 默认）", name = "password")
    private String password;

    @ApiModelProperty(value = "应用业务唯一编号（市场业务编号 不填 时间戳）", name = "taskId")
    private String taskId;

    @ApiModelProperty(value = "应用商户名称（市场名称 不填默认 JHScale）", name = "merchant")
    private String merchant;

    @ApiModelProperty(value = "操作人姓名（不填 默认JHScale）", name = "operator")
    private String operator;
}
