package com.jhscale.network.entity.sh;

import com.jhscale.common.model.http.JResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author lie_w
 * @title: SHIDObtainRequest
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1216:00
 */
@Data
@ApiModel("上海证件照获取响应")
@NoArgsConstructor
@AllArgsConstructor
public class SHIDObtainResponse extends JResponse {

    @ApiModelProperty(value = "证件照URL", name = "url")
    private String url;

    @ApiModelProperty(value = "证件照BASE64", name = "base64")
    private List<String> base64;

    public SHIDObtainResponse(String url) {
        this.url = url;
    }

    public SHIDObtainResponse(List<String> base64) {
        this.base64 = base64;
    }
}
