package com.jhscale.network.entity.telecom.req;

import com.jhscale.network.entity.food.AbstractMarketRequest;
import com.jhscale.network.entity.telecom.res.TelecomGetStreamUrlResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/9/14 18:49
 * 电信监控服务获取视频流地址
 */
@NoArgsConstructor
@ApiModel
@Data
public class TelecomGetStreamUrlRequest extends AbstractMarketRequest<TelecomGetStreamUrlResponse> {

    public TelecomGetStreamUrlRequest(String mkId, String urlPrefix, String guid) {
        setMarketId(mkId);
        setUrlPrefix(urlPrefix);
        this.guid = guid;
    }

    @ApiModelProperty(value = "统⼀设备管理平台中设备通道唯⼀标识", name = "guid", required = true)
    private String guid;

    @ApiModelProperty(value = "视频协议 1:rtsp 2:hls 3:flv 4:rtmp，不填默认rtsp。\n" +
            "⼤华：⽀持rtsp、hls\n" +
            "中兴：⽀持rtsp\n" +
            "天翼云眼：⽀持rtsp、hls", name = "proto")
    private Integer proto;

    @ApiModelProperty(value ="访问类型，接⼊⽹络类型\n" +
            "0：内⽹，1：公⽹，2: 其他", name = "accessType")
    private Integer accessType;

    @ApiModelProperty(value = "码流类型 0：主码流、1：⼦码流、 2：第三码流。\n" +
            "不填默认为主码流。\n" +
            "天翼云眼：0：⾼清，1：标清", name = "streamType")
    private Integer streamType;


    @Override
    public RequestMethod method() {
        return RequestMethod.POST;
    }

    /**
     * @description: 响应类型
     **/
    @Override
    public Class<TelecomGetStreamUrlResponse> resClass() {
        return TelecomGetStreamUrlResponse.class;
    }

    /**
     * @description: URL 地址
     **/
    @Override
    public String url() {
        return "vdmp/api/device/getStreamUrl";
    }

}
