package com.jhscale.network.entity.telecom.req;

import com.jhscale.network.entity.food.AbstractMarketRequest;
import com.jhscale.network.entity.telecom.res.TelecomListDeviceResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/9/14 18:49
 * 电信监控服务获取设备列表
 */
@NoArgsConstructor
@ApiModel
@Data
public class TelecomListDeviceRequest extends AbstractMarketRequest<TelecomListDeviceResponse> {

    public TelecomListDeviceRequest(String mkId, String urlPrefix, Integer pageSize, Integer pageNum) {
        setMarketId(mkId);
        setUrlPrefix(urlPrefix);
        this.pageSize = pageSize;
        this.pageNum = pageNum;
    }

    @ApiModelProperty(value = "每⻚记录数取值范围(1-1000)，不传默认100", name = "pageSize")
    private Integer pageSize;

    @ApiModelProperty(value = "当前⻚，不传默认1", name = "pageNum")
    private Integer pageNum;


    @Override
    public RequestMethod method() {
        return RequestMethod.POST;
    }

    /**
     * @description: 响应类型
     **/
    @Override
    public Class<TelecomListDeviceResponse> resClass() {
        return TelecomListDeviceResponse.class;
    }

    /**
     * @description: URL 地址
     **/
    @Override
    public String url() {
        return "vdmp/api/device/listDevice";
    }

}
