package com.jhscale.network.entity.telecom.req;

import com.jhscale.network.entity.food.AbstractMarketRequest;
import com.jhscale.network.entity.telecom.res.TelecomLoginResponse;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/9/14 18:49
 * 电信监控服务登录
 */
@NoArgsConstructor
@ApiModel
@Data
public class TelecomLoginRequest extends AbstractMarketRequest<TelecomLoginResponse> {

    public TelecomLoginRequest(String mkId, String urlPrefix, String appId, String appKey) {
        setMarketId(mkId);
        setUrlPrefix(urlPrefix);
        this.appId = appId;
        this.appKey = appKey;
    }

    @ApiModelProperty(value = "appId", name = "appId", required = true)
    private String appId;
    @ApiModelProperty(value = "appKey", name = "appKey", required = true)
    private String appKey;

    @Override
    public RequestMethod method() {
        return RequestMethod.GET;
    }

    /**
     * @description: URL 地址
     **/
    @Override
    public String url() {
        return "vdmp/v1/token/" + appId;
    }

    /**
     * @description: 响应类型
     **/
    @Override
    public Class<TelecomLoginResponse> resClass() {
        return TelecomLoginResponse.class;
    }
}
