package com.jhscale.network.entity.telecom.res;

import com.jhscale.common.model.simple.JSONModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author lj
 * @title:
 * @projectName rely-on-utils
 * @description:
 * @date 2023/9/15 10:07
 */
public class TelecomListDeviceResponse extends BaseTelecomResponse<TelecomListDeviceResponse.TData> {

    @ApiModel
    @Data
    public static class TData extends JSONModel {
        @ApiModelProperty(value = "每⻚⼏条记录")
        private Integer pageSize;
        @ApiModelProperty(value = "当前⻚")
        private Integer pageNum;
        @ApiModelProperty(value = "总⻚数")
        private Integer pages;
        @ApiModelProperty(value = "总记录数")
        private Integer total;
        @ApiModelProperty(value = "设备信息列表")
        private List<TelecomListDevice> list;
    }

    @ApiModel
    @Data
    public static class TelecomListDevice extends JSONModel {
        @ApiModelProperty(value = "", notes = "")
        private String guid;
        @ApiModelProperty(value = "通道名称", notes = "")
        private String name;
        @ApiModelProperty(value = "地址", notes = "")
        private String address;
        @ApiModelProperty(value = "省份", notes = "")
        private String province;
        @ApiModelProperty(value = "市", notes = "")
        private String city;
        @ApiModelProperty(value = "区", notes = "")
        private String district;
        @ApiModelProperty(value = "街镇", notes = "")
        private String town;
        @ApiModelProperty(value = "⼩区", notes = "")
        private String community;
        @ApiModelProperty(value = "区局", notes = "")
        private String station;
        @ApiModelProperty(value = "分局", notes = "")
        private String subStation;
        @ApiModelProperty(value = "设备状态：1:在线 0:离线", notes = "")
        private Integer status;
        @ApiModelProperty(value = "国标编号", notes = "")
        private String gbCode;
        @ApiModelProperty(value = "对应各平台的通道标识，映射关系如下：\n" +
                "⼤华：通道号 channelId\n" +
                "中兴平台：通道编号 guid\n" +
                "天翼云眼：⽆通道标识，暂⽤设备编号取代", notes = "")
        private String channelNo;
        @ApiModelProperty(value = "对应各平台的设备标识，映射关系如下：\n" +
                "⼤华：设备编号 deviceCode\n" +
                "中兴平台：设备编号 puid\n" +
                "天翼云眼：设备编号 deviceCode", notes = "")
        private String deviceCode;
        @ApiModelProperty(value = "通道序号，统⼀从0开始，中兴平台后续定制开发", notes = "")
        private Integer channelSeq;
        @ApiModelProperty(value = "⽤户标识，对应中兴平台⽤户标识", notes = "")
        private String identity;
        @ApiModelProperty(value = "⽤户群组，对应中兴平台⽤户群组", notes = "")
        private String identityGroup;
        @ApiModelProperty(value = "设备所属平台编号。⼤华:QQY、中兴:TYBD、天翼云眼TYYY", notes = "")
        private String vendorCode;
        @ApiModelProperty(value = "设备型号", notes = "")
        private String deviceModel;
        @ApiModelProperty(value = "设备sn号", notes = "")
        private String deviceSn;
        @ApiModelProperty(value = "设备⼚商", notes = "")
        private String deviceManufacturer;
        @ApiModelProperty(value = "摄像头类型 （其他:0、枪机:1、球机:2、半球:3）", notes = "")
        private Integer cameraType;
        @ApiModelProperty(value = "设备接⼊类型（其他:0、DVR:1、IPC:2、NVR:3)", notes = "")
        private Integer deviceType;
        @ApiModelProperty(value = "设备协议类型，GB28181:1、ONVIF:2", notes = "")
        private Integer protocol;
        @ApiModelProperty(value = "经度", notes = "")
        private String lng;
        @ApiModelProperty(value = "纬度", notes = "")
        private String lat;
        @ApiModelProperty(value = "IP地址", notes = "")
        private String ip;
        @ApiModelProperty(value = "云存状态（1:有效、0:⽆效）", notes = "")
        private Integer cloudStatus;
        @ApiModelProperty(value = "绑定状态（1:已绑定、0:待绑定）", notes = "")
        private Integer bandStatus;
        @ApiModelProperty(value = "最近的绑定时间，格式：yyyy-MM-dd HH:mm:ss", notes = "")
        private String importTime;
        @ApiModelProperty(value = "云存套餐信息", notes = "")
        private String packageInfo;
        @ApiModelProperty(value = "平台Id", notes = "")
        private Integer platformid;
        @ApiModelProperty(value = "平台名称", notes = "")
        private String platformName;
        @ApiModelProperty(value = "⼚商id", notes = "")
        private Integer factoryId;
        @ApiModelProperty(value = "设备类型", notes = "")
        private String deviceFactory;
        @ApiModelProperty(value = "设备固件版本", notes = "")
        private String firmwareVersion;
        @ApiModelProperty(value = "国标id", notes = "")
        private String gbId;
        @ApiModelProperty(value = "全链接区域名称", notes = "")
        private String fullRegionName;
        @ApiModelProperty(value = "设备CTEI嘛", notes = "")
        private String ctei;
        @ApiModelProperty(value = "是否⾃⼰绑定的设备", notes = "")
        private Integer isSelfBind;
    }

}