package com.jhscale.network.service.impl;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.HttpUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.network.NetWorkConstant;
import com.jhscale.network.config.NetWorkConfig;
import com.jhscale.network.entity.sh.*;
import com.jhscale.network.exp.RNetWorkException;
import com.jhscale.network.exp.RNetWorkInternational;
import com.jhscale.network.service.IDCertService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author lie_w
 * @title: IDCertServiceImpl
 * @projectName Rely-On-Utils
 * @description: TODO
 * @date 2022/10/1215:59
 */
@Slf4j
@Service
public class IDCertServiceImpl implements IDCertService {

    @Autowired
    private NetWorkConfig netWorkConfig;


    /**
     * @param request
     * @description: 上海证件照获取请求
     */
    @Override
    public SHIDObtainResponse shanghai(SHIDObtainRequest request) throws ProfessionalException {
        // 获取Token
        String token = this.token();
        // 2.1 	亮证扫码解码
        SHCertQRDecodeRequest shCertQRDecodeRequest = new SHCertQRDecodeRequest();
        shCertQRDecodeRequest.setQrCode(request.getQr());
        SHCertQRDecodeResponse shCertQRDecodeResponse = this.obtain("2000101", shCertQRDecodeRequest,
                request.getAccount(), request.getPassword(),
                request.getTaskId(), request.getMerchant(), request.getOperator(),
                token, SHCertQRDecodeResponse.class,
                RNetWorkInternational.亮证解码获取失败, RNetWorkInternational.亮证解码拆包失败, RNetWorkInternational.亮证解码拆内包失败);
        log.debug("SHCertQRDecodeResponse:{}", shCertQRDecodeResponse.toJSON());

        if (Objects.isNull(request.getType()) || request.getType() == 0) {
            SHCertJPGResponse shCertJPGResponse = this.obtain("3000105",
                    new SHCertJPGRequest(shCertQRDecodeResponse.getCertUuid(),
                            StringUtils.isNotBlank(request.getNumber()) ? request.getNumber() : NetWorkConstant.SH_CERT_DEFAULT_NUMBER,
                            StringUtils.isNotBlank(request.getWatermark()) ? request.getWatermark() : NetWorkConstant.SH_CERT_DEFAULT_WATERMARK),
                    request.getAccount(), request.getPassword(),
                    request.getTaskId(), request.getMerchant(), request.getOperator(),
                    token, SHCertJPGResponse.class,
                    RNetWorkInternational.电子营业执照图片获取失败, RNetWorkInternational.电子营业执照图片拆包失败, RNetWorkInternational.电子营业执照图片拆内包失败);
            log.debug("SHCertJPGResponse:{}", shCertJPGResponse.toJSON());
            return new SHIDObtainResponse(String.format(netWorkConfig.getShCertDownload(), shCertJPGResponse.getThumbnailId(),
                    (Objects.isNull(request.getOpen()) || request.getOpen() == 0) ? "inline" : "attachment"));
        } else {
            List shCertJPGJSONResponse = this.obtain("3000106",
                    new SHCertJPGJSONRequest(shCertQRDecodeResponse.getCertUuid(),
                            StringUtils.isNotBlank(request.getNumber()) ? request.getNumber() : NetWorkConstant.SH_CERT_DEFAULT_NUMBER,
                            StringUtils.isNotBlank(request.getWatermark()) ? request.getWatermark() : NetWorkConstant.SH_CERT_DEFAULT_WATERMARK),
                    request.getAccount(), request.getPassword(),
                    request.getTaskId(), request.getMerchant(), request.getOperator(),
                    token, List.class,
                    RNetWorkInternational.电子营业执照Base64获取失败, RNetWorkInternational.电子营业执照Base64拆包失败, RNetWorkInternational.电子营业执照Base64拆内包失败);
            log.debug("SHCertJPGResponse:{}", JSONUtils.objectToJSON(shCertJPGJSONResponse));
            return new SHIDObtainResponse(shCertJPGJSONResponse);
        }
    }

    /**
     * @description: 2.1    亮证扫码解码
     **/
    private <T> T obtain(String tradeCode, JSONModel model,
                         String account, String password,
                         String taskId, String merchant, String operator,
                         String token, Class<T> clazz,
                         RNetWorkInternational international1, RNetWorkInternational international2, RNetWorkInternational international3) throws ProfessionalException {
        SHCertRequest request = new SHCertRequest();
        request.defaultTradeToken(StringUtils.isBlank(account) ? netWorkConfig.getShCertAccount() : account,
                StringUtils.isBlank(password) ? netWorkConfig.getShCertPassword() : password)
                .addParam(tradeCode, taskId, merchant, operator)
                .addMessage(model);
        log.debug("SHCert Obtain Request:{}", request.toJSON());
        Map<String, String> head = new HashMap<>();
        head.put("Authorization", StringUtils.isNotBlank(token) ? token : this.token());
        String post = HttpUtils.post("http://cert.qpservice.org.cn/cert/certController.do?orgLic",
                request.toJSON(), head);
        log.debug("SHCert Obtain Response:{}", post);
        if (StringUtils.isBlank(post))
            throw new RNetWorkException(international1);
        SHCertResponse shCertResponse = JSONUtils.jsonToObject(post, SHCertResponse.class);
        if (Objects.isNull(shCertResponse))
            throw new RNetWorkException(international2);
        T t = shCertResponse.toInnerBody(clazz);
        if (t == null)
            throw new RNetWorkException(international3);
        return t;
    }

    /**
     * @description: 获取Token
     **/
    private String token() throws RNetWorkException {
        String post = HttpUtils.post("https://e-cert.sheca.com/sdlv3/v3/sdl/api/getToken",
                new SHCertTokenRequest(netWorkConfig.getShCertAppId(), netWorkConfig.getShCertAppSecret()).toJSON());
        log.debug("Token Response:{}", post);
        if (StringUtils.isBlank(post))
            throw new RNetWorkException(RNetWorkInternational.Token获取失败);
        SHCertResponse shCertResponse = JSONUtils.jsonToObject(post, SHCertResponse.class);
        if (Objects.isNull(shCertResponse))
            throw new RNetWorkException(RNetWorkInternational.Token拆包失败);
        SHCertTokenResponse response = shCertResponse.toBody(SHCertTokenResponse.class);
        if (response == null || StringUtils.isBlank(response.getToken()))
            throw new RNetWorkException(RNetWorkInternational.Token拆内包失败);
        return response.getToken();
    }
}
