package com.jhscale.network.utils;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.UnsupportedEncodingException;
import java.security.*;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;

/**
 * SM2<br>
 *
 * @author 谭驰舰
 * @version 1.8 <br>
 * created 2021/05/12 <br>
 */
public class MS2Helper { // Mode.C1C2C3

    //SM2算法公钥值
    public final static String publicKeyS = "04fe2e8f09df8f7458c72f46ed71ef6d554d8d8595b39fa568dc5f37268ce7bd4fb8208b6e3d6e5515955aae1d4b1b5d1e3a2891def744b53a8436eb285f5a8f30";
    public final static String tradeToken_user = "qptest";
    public final static String tradeToken_pwd = "QPfwzx6189";

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    private static X9ECParameters x9ecParameters = GMNamedCurves.getByName("sm2p256v1");

    private static ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ecParameters.getCurve(),
            x9ecParameters.getG(), x9ecParameters.getN(), x9ecParameters.getH());

    private static KeyFactory keyFactory;

    static {
        try {
            keyFactory = KeyFactory.getInstance("EC", new BouncyCastleProvider());
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encrypt(String publicKeyS, byte[] plainContent) {
        try {
            ECPoint publicKey = x9ecParameters.getCurve().decodePoint(Hex.decodeHex(publicKeyS.toCharArray()));
            BCECPublicKey bcecPublicKey = (BCECPublicKey) keyFactory
                    .generatePublic(new ECPublicKeySpec(publicKey, ecParameterSpec));
            Cipher cipher = Cipher.getInstance("SM2", BouncyCastleProvider.PROVIDER_NAME);
            cipher.init(Cipher.ENCRYPT_MODE, bcecPublicKey);
            return cipher.doFinal(plainContent);
        } catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        } catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        } catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        } catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        } catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        } catch (BadPaddingException e) {
            throw new RuntimeException(e);
        } catch (DecoderException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取TradeToken信息 自己传账号密码信息
     *
     * @param tradeToken_user
     * @param tradeToken_pwd
     * @return
     */
    public static String getTradeToken(String tradeToken_user, String tradeToken_pwd) {
        String plainText = tradeToken_user + "#" + tradeToken_pwd + "#" + new Date().getTime();
        byte[] bytes = new byte[0];
        try {
            bytes = encrypt(publicKeyS, plainText.getBytes("UTF-8"));
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String cipherText = Hex.encodeHexString(bytes);
        return cipherText;
    }

//    public static void main(String[] args) throws Exception {
//        String plainText = tradeToken_user + "#" + tradeToken_pwd + "#" + new Date().getTime();
////        byte[] bytes = encrypt(publicKeyS, plainText.getBytes("UTF-8"));
////        String cipherText = Hex.encodeHexString(bytes);
////        System.out.println("密文：" + cipherText);
//
//        String uer = "qianjingjing";
//        String pwd = "2wsxCSQ!451";
//        System.out.println(getTradeToken(uer,pwd));
//    }

}
