package com.ysscale.scan;

import com.ysscale.framework.exception.SystemException;
import com.ysscale.scan.service.QrCodeManagement;
import com.ysscale.scan.vo.QrCodeInfoReq;
import com.ysscale.scan.vo.QrCodeInfoRes;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/**
 * @author lie_w
 * @title: ScanConfiguaration
 * @projectName assist-core
 * @description: TODO
 * @date 2019/6/40:35
 */
@ComponentScan
@Configuration
public class ScanConfiguaration {

    /**
     * @description: 用于负载均衡
     **/
    @Bean("loadBalancedRestTemplate")
    @LoadBalanced
    public RestTemplate loadBalancedRestemplate() {
        return new RestTemplate(httpRequestFactory());
    }

    @Bean("defaultRestTemplate")
    public RestTemplate defaultRestTemplate() {
        return new RestTemplate(httpRequestFactory());
    }

    private SimpleClientHttpRequestFactory httpRequestFactory() {
        SimpleClientHttpRequestFactory httpRequestFactory = new SimpleClientHttpRequestFactory();
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(3000);
        return httpRequestFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public QrCodeManagement qrCodeManagement() {
        return new QrCodeManagement() {
            @Override
            public QrCodeInfoRes transmit(QrCodeInfoReq qrCodeInfoReq) throws SystemException {
                throw new SystemException("qrCode transmit error");
            }
        };
    }

}
