package com.ysscale.scan.controller;

import com.ysscale.framework.exception.CommonException;
import com.ysscale.scan.service.QrCodeManagement;
import com.ysscale.scan.utils.ScanOperateConstants;
import com.ysscale.scan.vo.QrCodeInfoReq;
import com.ysscale.scan.vo.QrCodeInfoRes;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lie_w
 * @title: QrCodeController
 * @projectName assist-core
 * @description: TODO
 * @date 2019/6/41:00
 */
@RestController
public class QrCodeController {

    @Autowired
    private QrCodeManagement qrCodeManagement;

    @PostMapping(ScanOperateConstants.QRCODE_TRANSMIT)
    public QrCodeInfoRes transmit(@RequestBody QrCodeInfoReq qrCodeInfoReq) throws CommonException {
        return qrCodeManagement.transmit(qrCodeInfoReq);
    }
}
