package com.ysscale.scan.entity;

import com.ysscale.scan.em.QrCodeLoseType;
import lombok.Data;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: ServerInfo
 * @projectName assist-core
 * @description: TODO
 * @date 2019/6/41:31
 */
@Data
public class ServerInfo {

    /**
     * 简写标识
     */
    private String abbr;

    /**
     * 内容
     */
    private Map<String, Object> content = new HashMap<>();

    /**
     * 失效标志
     */
    private QrCodeLoseType lostType;

    /**
     * 保存标志
     */
    private String key;

    /**
     * 二维码有效期
     */
    private long validTime;

    public ServerInfo() {
    }

    public ServerInfo(String[] contentArr) {
        try {
            this.abbr = contentArr[0];

            if (StringUtils.isNotBlank(contentArr[1])) {
                String[] contetMapArr = contentArr[1].split("#");
                if (contetMapArr != null && contetMapArr.length != 0) {
                    for (String contentMapStr : contetMapArr) {
                        String[] split = contentMapStr.split("!");
                        content.put(split[0], split[1]);
                    }
                }
            }

            String content = contentArr[2];
            String[] loseArr = content.split("-");
            this.lostType = QrCodeLoseType.BEFORE.getType().equals(loseArr[0]) ?
                    QrCodeLoseType.BEFORE
                    :
                    (QrCodeLoseType.AFTER.getType().equals(loseArr[0]) ? QrCodeLoseType.AFTER : QrCodeLoseType.FOREVER);
            if (loseArr.length == 2) {
                this.key = loseArr[1];
            }

            this.validTime = Long.parseLong(contentArr[3]);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
