package com.ysscale.scan.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author lie_w
 * @title: QrCodeInfo
 * @projectName assist-core
 * @description: TODO
 * @date 2019/6/40:40
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class QrCodeInfoRes {

    /**
     * 业务状态，true 成功 false 失败
     */
    private boolean state;

    /**
     * 状态码
     */
    private int code;

    /**
     * 业务成功返回数据
     */
    private Object data;

    /**
     * 业务失败返回异常信息
     */
    private String msg;

    public static QrCodeInfoRes ok(Object data) {
        return new QrCodeInfoRes(true, 200, data, null);
    }

    public static QrCodeInfoRes fail(String msg) {
        return new QrCodeInfoRes(false, 45000, null, msg);
    }

    public static QrCodeInfoRes fail(int code, String msg) {
        return new QrCodeInfoRes(false, code, null, msg);
    }
}
