/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.scan;

import com.ysscale.framework.exception.SystemException;
import com.ysscale.scan.service.QrCodeManagement;
import com.ysscale.scan.vo.QrCodeInfoReq;
import com.ysscale.scan.vo.QrCodeInfoRes;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@ComponentScan
@Configuration
public class ScanConfiguaration {
    @Bean(value={"loadBalancedRestTemplate"})
    @LoadBalanced
    public RestTemplate loadBalancedRestemplate() {
        return new RestTemplate((ClientHttpRequestFactory)this.httpRequestFactory());
    }

    @Bean(value={"defaultRestTemplate"})
    public RestTemplate defaultRestTemplate() {
        return new RestTemplate((ClientHttpRequestFactory)this.httpRequestFactory());
    }

    private SimpleClientHttpRequestFactory httpRequestFactory() {
        SimpleClientHttpRequestFactory httpRequestFactory = new SimpleClientHttpRequestFactory();
        httpRequestFactory.setConnectTimeout(3000);
        httpRequestFactory.setReadTimeout(3000);
        return httpRequestFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public QrCodeManagement qrCodeManagement() {
        return new QrCodeManagement(){

            @Override
            public QrCodeInfoRes transmit(QrCodeInfoReq qrCodeInfoReq) throws SystemException {
                throw new SystemException("qrCode transmit error", new Object[0]);
            }
        };
    }
}

