/*
 * Decompiled with CFR 0.152.
 */
package com.ysscale.scan.utils;

import com.ysscale.framework.exception.BusinessException;
import com.ysscale.framework.exception.CommonException;
import com.ysscale.framework.exception.SystemException;
import com.ysscale.framework.utils.AESUtils;
import com.ysscale.framework.utils.ConfigHelper;
import com.ysscale.framework.utils.MapXml;
import com.ysscale.scan.em.QrCodeLoseType;
import com.ysscale.scan.entity.ServerInfo;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeBulid {
    private static final Logger LOGGER = LoggerFactory.getLogger(QrCodeBulid.class);
    private static String REALMS = "https://scan.s.jhscale.com/?c=";
    private static String REALM = "http://scan.jhscale.com/?c=";
    public static final String MIN = "min";
    public static final String HOUR = "hour";
    public static final String DAY = "day";
    public static final String TIME = "time";

    public static String httpsHandleLose(String server, String content, String type, int num) throws SystemException {
        return QrCodeBulid.getQrCodeUrl(server, content, type, num, REALMS, QrCodeLoseType.AFTER);
    }

    public static String httpHandleLose(String server, String content, String type, int num) throws SystemException {
        return QrCodeBulid.getQrCodeUrl(server, content, type, num, REALMS, QrCodeLoseType.AFTER);
    }

    public static String httpsScanLose(String server, String content, String type, int num) throws SystemException {
        return QrCodeBulid.getQrCodeUrl(server, content, type, num, REALMS, QrCodeLoseType.BEFORE);
    }

    public static String httpScanLose(String server, String content, String type, int num) throws SystemException {
        return QrCodeBulid.getQrCodeUrl(server, content, type, num, REALM, QrCodeLoseType.BEFORE);
    }

    public static String https(String server, String content, String type, int num) throws SystemException {
        return QrCodeBulid.getQrCodeUrl(server, content, type, num, REALMS, QrCodeLoseType.FOREVER);
    }

    public static String http(String server, String content, String type, int num) throws SystemException {
        return QrCodeBulid.getQrCodeUrl(server, content, type, num, REALM, QrCodeLoseType.FOREVER);
    }

    private static String getQrCodeUrl(String server, String content, String type, int num, String realm, QrCodeLoseType loseType) throws SystemException {
        switch (type) {
            case "time": {
                return realm + QrCodeBulid.encrype(server, content, loseType, num);
            }
            case "min": {
                return realm + QrCodeBulid.encrypeWithValidMin(server, content, loseType, num);
            }
            case "hour": {
                return realm + QrCodeBulid.encrypeWithValidHour(server, content, loseType, num);
            }
            case "day": {
                return realm + QrCodeBulid.encrypeWithValidDay(server, content, loseType, num);
            }
        }
        return realm + QrCodeBulid.encrype(server, content, loseType, -1L);
    }

    private static String encrypeWithValidMin(String server, String content, QrCodeLoseType loseType, int num) throws SystemException {
        return QrCodeBulid.encrype(server, content, loseType, System.currentTimeMillis() + (long)(num * 60000));
    }

    private static String encrypeWithValidHour(String server, String content, QrCodeLoseType loseType, int num) throws SystemException {
        return QrCodeBulid.encrype(server, content, loseType, System.currentTimeMillis() + (long)(num * 3600000));
    }

    private static String encrypeWithValidDay(String server, String content, QrCodeLoseType loseType, int num) throws SystemException {
        return QrCodeBulid.encrype(server, content, loseType, System.currentTimeMillis() + (long)(num * 86400000));
    }

    private static String encrype(String server, String content, QrCodeLoseType loseType, long validTime) throws SystemException {
        String lose = loseType.getType() + "-";
        if (loseType != QrCodeLoseType.FOREVER) {
            String key = String.valueOf(System.currentTimeMillis()).substring(3);
            lose = lose + key;
        }
        String valid = "";
        if (validTime != 0L) {
            valid = String.valueOf(validTime);
        }
        return AESUtils.aesEncrypt((String)(server + "&" + content + "&" + lose + "&" + valid));
    }

    public static ServerInfo decrypt(String content) throws CommonException {
        String[] contentArr = (content = AESUtils.aesDecrypt((String)content)).split("&");
        if (contentArr != null && contentArr.length == 4) {
            return new ServerInfo(contentArr);
        }
        throw new BusinessException("\u4e8c\u7ef4\u7801\u65e0\u6548");
    }

    public static String buildContent(String sgin, Object data) {
        Map map;
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotBlank((String)sgin)) {
            sb.append("sgin!" + sgin + "#");
        }
        if (Objects.nonNull(data) && (map = MapXml.toMap((Object)data)) != null && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Object valObj = map.get(key);
                if (!Objects.nonNull(valObj)) continue;
                sb.append(key + "!" + valObj.toString() + "#");
            }
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static String buildContent(Object data) {
        return QrCodeBulid.buildContent("", data);
    }

    static {
        try {
            ConfigHelper helper = new ConfigHelper("scan.properties");
            String https = helper.getStringValue("scan.https");
            String http = helper.getStringValue("scan.http");
            if (StringUtils.isNotBlank((String)https)) {
                REALMS = https;
            }
            if (StringUtils.isNotBlank((String)http)) {
                REALM = http;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8bfb\u53d6\u626b\u7801\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u57df\u540d\u914d\u7f6e\u4fe1\u606f");
        }
    }
}

