/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.access;

import io.fabric8.maven.docker.access.ContainerHostConfig;
import io.fabric8.maven.docker.access.ContainerNetworkingConfig;
import io.fabric8.maven.docker.config.Arguments;
import io.fabric8.maven.docker.util.EnvUtil;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.text.StrSubstitutor;
import org.json.JSONArray;
import org.json.JSONObject;

public class ContainerCreateConfig {
    private final JSONObject createConfig = new JSONObject();
    private final String imageName;

    public ContainerCreateConfig(String imageName) {
        this.imageName = imageName;
        this.createConfig.put("Image", (Object)imageName);
    }

    public ContainerCreateConfig binds(List<String> volumes) {
        if (volumes != null && !volumes.isEmpty()) {
            JSONObject extractedVolumes = new JSONObject();
            for (String volume : volumes) {
                extractedVolumes.put(this.extractContainerPath(volume), (Object)new JSONObject());
            }
            this.createConfig.put("Volumes", (Object)extractedVolumes);
        }
        return this;
    }

    public ContainerCreateConfig command(Arguments command) {
        if (command != null) {
            this.createConfig.put("Cmd", (Object)new JSONArray(command.asStrings()));
        }
        return this;
    }

    public ContainerCreateConfig domainname(String domainname) {
        return this.add("Domainname", domainname);
    }

    public ContainerCreateConfig entrypoint(Arguments entrypoint) {
        if (entrypoint != null) {
            this.createConfig.put("Entrypoint", (Object)new JSONArray(entrypoint.asStrings()));
        }
        return this;
    }

    public ContainerCreateConfig environment(String envPropsFile, Map<String, String> env, Map mavenProps) throws IllegalArgumentException {
        Properties envProps = new Properties();
        if (env != null && env.size() > 0) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                String value = entry.getValue();
                if (value == null) {
                    value = "";
                } else if (value.matches("^\\+\\$\\{.*}$")) {
                    value = value.substring(1, value.length());
                }
                envProps.put(entry.getKey(), StrSubstitutor.replace((Object)value, (Map)mavenProps));
            }
        }
        if (envPropsFile != null) {
            this.addPropertiesFromFile(envPropsFile, envProps);
        }
        if (envProps.size() > 0) {
            this.addEnvironment(envProps);
        }
        return this;
    }

    public ContainerCreateConfig labels(Map<String, String> labels) {
        if (labels != null && labels.size() > 0) {
            this.createConfig.put("Labels", (Object)new JSONObject(labels));
        }
        return this;
    }

    public ContainerCreateConfig exposedPorts(Set<String> portSpecs) {
        if (portSpecs != null && portSpecs.size() > 0) {
            JSONObject exposedPorts = new JSONObject();
            for (String portSpec : portSpecs) {
                exposedPorts.put(portSpec, (Object)new JSONObject());
            }
            this.createConfig.put("ExposedPorts", (Object)exposedPorts);
        }
        return this;
    }

    public String getImageName() {
        return this.imageName;
    }

    public ContainerCreateConfig hostname(String hostname) {
        return this.add("Hostname", hostname);
    }

    public ContainerCreateConfig user(String user) {
        return this.add("User", user);
    }

    public ContainerCreateConfig workingDir(String workingDir) {
        return this.add("WorkingDir", workingDir);
    }

    public ContainerCreateConfig hostConfig(ContainerHostConfig startConfig) {
        return this.add("HostConfig", startConfig.toJsonObject());
    }

    public ContainerCreateConfig networkingConfig(ContainerNetworkingConfig networkingConfig) {
        return this.add("NetworkingConfig", networkingConfig.toJsonObject());
    }

    public String toJson() {
        return this.createConfig.toString();
    }

    private ContainerCreateConfig add(String name, Object value) {
        if (value != null) {
            this.createConfig.put(name, value);
        }
        return this;
    }

    private String extractContainerPath(String volume) {
        String[] parts;
        String path = EnvUtil.fixupPath(volume);
        if (path.contains(":") && (parts = path.split(":")).length > 1) {
            return parts[1];
        }
        return path;
    }

    private void addEnvironment(Properties envProps) {
        JSONArray containerEnv = new JSONArray();
        Enumeration<Object> keys = envProps.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = envProps.getProperty(key);
            if (value == null) {
                value = "";
            }
            containerEnv.put((Object)(key + "=" + value));
        }
        this.createConfig.put("Env", (Object)containerEnv);
    }

    private void addPropertiesFromFile(String envPropsFile, Properties envProps) {
        try {
            FileReader reader = new FileReader(envPropsFile);
            envProps.load(reader);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(String.format("Cannot find environment property file '%s'", envPropsFile));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Error while loading environment properties: %s", e.getMessage()), e);
        }
    }
}

