/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.definition.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import io.servicecomb.core.definition.MicroserviceMeta;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.core.definition.SchemaMeta;
import io.servicecomb.core.definition.schema.AbstractSchemaFactory;
import io.servicecomb.core.definition.schema.ProducerSchemaContext;
import io.servicecomb.serviceregistry.RegistryUtils;
import io.servicecomb.swagger.engine.SwaggerEnvironment;
import io.servicecomb.swagger.engine.SwaggerProducer;
import io.servicecomb.swagger.engine.SwaggerProducerOperation;
import io.servicecomb.swagger.generator.core.SwaggerGenerator;
import io.swagger.models.Swagger;
import io.swagger.util.Yaml;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProducerSchemaFactory
extends AbstractSchemaFactory<ProducerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProducerSchemaFactory.class);
    @Inject
    private SwaggerEnvironment swaggerEnv;
    private ObjectWriter writer = Yaml.pretty();

    private String getSwaggerContent(Swagger swagger) {
        try {
            return this.writer.writeValueAsString((Object)swagger);
        }
        catch (JsonProcessingException e) {
            throw new Error(e);
        }
    }

    public void setSwaggerEnv(SwaggerEnvironment swaggerEnv) {
        this.swaggerEnv = swaggerEnv;
    }

    public SchemaMeta getOrCreateProducerSchema(String microserviceName, String schemaId, Class<?> producerClass, Object producerInstance) {
        MicroserviceMeta microserviceMeta = this.microserviceMetaManager.getOrCreateMicroserviceMeta(microserviceName);
        ProducerSchemaContext context = new ProducerSchemaContext();
        context.setMicroserviceMeta(microserviceMeta);
        context.setSchemaId(schemaId);
        context.setProviderClass(producerClass);
        context.setProducerInstance(producerInstance);
        SchemaMeta schemaMeta = this.getOrCreateSchema(context);
        SwaggerProducer producer = this.swaggerEnv.createProducer(producerInstance, schemaMeta.getSwagger());
        for (OperationMeta operationMeta : schemaMeta.getOperations()) {
            SwaggerProducerOperation producerOperation = producer.findOperation(operationMeta.getOperationId());
            operationMeta.putExtData("producer-operation", producerOperation);
        }
        return schemaMeta;
    }

    @Override
    protected SchemaMeta createSchema(ProducerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        if (swagger == null) {
            String name;
            Set combinedNames = RegistryUtils.getServiceRegistry().getCombinedMicroserviceNames();
            Iterator iterator = combinedNames.iterator();
            while (iterator.hasNext() && (swagger = this.loadSwagger(name = (String)iterator.next(), context.getSchemaId())) == null) {
            }
        }
        SwaggerGenerator generator = this.generateSwagger(context);
        if (swagger == null) {
            swagger = generator.getSwagger();
            String swaggerContent = this.getSwaggerContent(swagger);
            LOGGER.info("generate swagger for {}/{}/{}, swagger: {}", new Object[]{context.getMicroserviceMeta().getAppId(), context.getMicroserviceName(), context.getSchemaId(), swaggerContent});
        }
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }
}

