/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.endpoint;

import io.servicecomb.core.Transport;
import io.servicecomb.core.transport.TransportManager;
import io.servicecomb.serviceregistry.cache.CacheEndpoint;
import io.servicecomb.serviceregistry.cache.InstanceCache;
import io.servicecomb.serviceregistry.cache.InstanceCacheManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public abstract class AbstractEndpointsCache<ENDPOINT> {
    protected static InstanceCacheManager instanceCacheManager;
    protected static TransportManager transportManager;
    protected List<ENDPOINT> endpoints = new ArrayList<ENDPOINT>();
    protected String transportName;
    protected InstanceCache instanceCache = null;

    public static void init(InstanceCacheManager instanceCacheManager, TransportManager transportManager) {
        AbstractEndpointsCache.instanceCacheManager = instanceCacheManager;
        AbstractEndpointsCache.transportManager = transportManager;
    }

    public AbstractEndpointsCache(String appId, String microserviceName, String microserviceVersionRule, String transportName) {
        this.transportName = transportName;
        this.instanceCache = new InstanceCache(appId, microserviceName, microserviceVersionRule, null);
    }

    public List<ENDPOINT> getLatestEndpoints() {
        InstanceCache newCache = instanceCacheManager.getOrCreate(this.instanceCache.getAppId(), this.instanceCache.getMicroserviceName(), this.instanceCache.getMicroserviceVersionRule());
        if (!this.instanceCache.cacheChanged(newCache)) {
            return this.endpoints;
        }
        List<ENDPOINT> tmpEndpoints = this.createEndpoints(newCache);
        this.instanceCache = newCache;
        this.endpoints = tmpEndpoints;
        return this.endpoints;
    }

    protected List<ENDPOINT> createEndpoints(InstanceCache newCache) {
        Map<String, List<CacheEndpoint>> transportMap = this.getOrCreateTransportMap(newCache);
        return this.createEndpoints(transportMap);
    }

    protected List<ENDPOINT> createEndpoints(Map<String, List<CacheEndpoint>> transportMap) {
        ArrayList<ENDPOINT> tmpEndpoints = new ArrayList<ENDPOINT>();
        for (Map.Entry<String, List<CacheEndpoint>> entry : transportMap.entrySet()) {
            List<CacheEndpoint> endpointList;
            Transport transport = transportManager.findTransport(entry.getKey());
            if (transport == null || (endpointList = entry.getValue()) == null) continue;
            for (CacheEndpoint cacheEndpoint : endpointList) {
                ENDPOINT endpoint = this.createEndpoint(transport, cacheEndpoint);
                tmpEndpoints.add(endpoint);
            }
        }
        return tmpEndpoints;
    }

    private Map<String, List<CacheEndpoint>> getOrCreateTransportMap(InstanceCache newCache) {
        Map allTransportMap = newCache.getOrCreateTransportMap();
        if (StringUtils.isEmpty((Object)this.transportName)) {
            return allTransportMap;
        }
        HashMap<String, List<CacheEndpoint>> transportMap = new HashMap<String, List<CacheEndpoint>>();
        transportMap.put(this.transportName, (List<CacheEndpoint>)allTransportMap.get(this.transportName));
        return transportMap;
    }

    protected abstract ENDPOINT createEndpoint(Transport var1, CacheEndpoint var2);
}

