/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.core.executor;

import com.netflix.config.DynamicPropertyFactory;
import io.servicecomb.core.definition.OperationMeta;
import io.servicecomb.foundation.common.utils.BeanUtils;
import java.util.concurrent.Executor;

public final class ExecutorManager {
    public static final String KEY_EXECUTORS_DEFAULT = "cse.executors.default";
    public static final String EXECUTOR_GROUP_THREADPOOL = "cse.executor.groupThreadPool";
    public static final String EXECUTOR_REACTIVE = "cse.executor.reactive";
    public static final String EXECUTOR_DEFAULT = "cse.executor.groupThreadPool";

    private ExecutorManager() {
    }

    public static Executor findExecutor(OperationMeta operationMeta) {
        Executor executor = ExecutorManager.findByKey("cse.executors.Provider." + operationMeta.getSchemaQualifiedName());
        if (executor != null) {
            return executor;
        }
        executor = ExecutorManager.findByKey("cse.executors.Provider." + operationMeta.getSchemaMeta().getName());
        if (executor != null) {
            return executor;
        }
        executor = ExecutorManager.findByKey(KEY_EXECUTORS_DEFAULT);
        if (executor != null) {
            return executor;
        }
        return (Executor)BeanUtils.getBean((String)"cse.executor.groupThreadPool");
    }

    protected static Executor findByKey(String beanIdKey) {
        String beanId = DynamicPropertyFactory.getInstance().getStringProperty(beanIdKey, null).get();
        if (beanId != null) {
            return (Executor)BeanUtils.getBean((String)beanId);
        }
        return null;
    }
}

