/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.shardingsphere.core.PreparedQueryShardingEngine;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.optimize.api.statement.OptimizedStatement;
import org.apache.shardingsphere.core.optimize.encrypt.EncryptOptimizeEngineFactory;
import org.apache.shardingsphere.core.optimize.transparent.statement.TransparentOptimizedStatement;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rewrite.SQLRewriteEngine;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.router.masterslave.MasterSlaveRouter;
import org.apache.shardingsphere.core.rule.BaseRule;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.JDBCExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.schema.EncryptSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.MasterSlaveSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.ShardingSchema;
import org.apache.shardingsphere.shardingproxy.context.ShardingProxyContext;
import org.apache.shardingsphere.spi.database.DatabaseType;

public final class PreparedStatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final ShardingProxyContext SHARDING_PROXY_CONTEXT = ShardingProxyContext.getInstance();
    private final LogicSchema logicSchema;
    private final List<Object> parameters;

    @Override
    public SQLRouteResult route(String sql, DatabaseType databaseType) {
        if (this.logicSchema instanceof ShardingSchema) {
            return this.doShardingRoute(sql, databaseType);
        }
        if (this.logicSchema instanceof MasterSlaveSchema) {
            return this.doMasterSlaveRoute(sql);
        }
        return this.doEncryptRoute(sql);
    }

    private SQLRouteResult doShardingRoute(String sql, DatabaseType databaseType) {
        PreparedQueryShardingEngine shardingEngine = new PreparedQueryShardingEngine(sql, this.logicSchema.getShardingRule(), ShardingProxyContext.getInstance().getShardingProperties(), this.logicSchema.getMetaData(), databaseType, this.logicSchema.getParseEngine());
        return shardingEngine.shard(sql, this.parameters);
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = this.logicSchema.getParseEngine().parse(sql, true);
        TransparentOptimizedStatement optimizedStatement = new TransparentOptimizedStatement(sqlStatement);
        SQLRewriteEngine sqlRewriteEngine = new SQLRewriteEngine(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), (OptimizedStatement)optimizedStatement, sql);
        String rewriteSQL = sqlRewriteEngine.generateSQL().getSql();
        SQLRouteResult result = new SQLRouteResult((OptimizedStatement)optimizedStatement);
        for (String each : new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), this.logicSchema.getParseEngine(), ((Boolean)SHARDING_PROXY_CONTEXT.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(rewriteSQL, true)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, this.parameters)));
        }
        return result;
    }

    private SQLRouteResult doEncryptRoute(String sql) {
        EncryptSchema encryptSchema = (EncryptSchema)this.logicSchema;
        SQLStatement sqlStatement = encryptSchema.getParseEngine().parse(sql, true);
        OptimizedStatement optimizedStatement = EncryptOptimizeEngineFactory.newInstance((SQLStatement)sqlStatement).optimize((BaseRule)encryptSchema.getEncryptRule(), this.logicSchema.getMetaData().getTable(), sql, this.parameters, sqlStatement);
        SQLRewriteEngine sqlRewriteEngine = new SQLRewriteEngine(encryptSchema.getEncryptRule(), optimizedStatement, sql, this.parameters, ((Boolean)ShardingProxyContext.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.QUERY_WITH_CIPHER_COLUMN)).booleanValue());
        SQLRouteResult result = new SQLRouteResult(optimizedStatement);
        result.getRouteUnits().add(new RouteUnit(this.logicSchema.getDataSources().keySet().iterator().next(), new SQLUnit(sqlRewriteEngine.generateSQL().getSql(), this.parameters)));
        return result;
    }

    @Override
    public Statement createStatement(Connection connection, SQLUnit sqlUnit, boolean isReturnGeneratedKeys) throws SQLException {
        PreparedStatement result = isReturnGeneratedKeys ? connection.prepareStatement(sqlUnit.getSql(), 1) : connection.prepareStatement(sqlUnit.getSql());
        for (int i = 0; i < sqlUnit.getParameters().size(); ++i) {
            result.setObject(i + 1, sqlUnit.getParameters().get(i));
        }
        return result;
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return ((PreparedStatement)statement).execute();
    }

    @ConstructorProperties(value={"logicSchema", "parameters"})
    public PreparedStatementExecutorWrapper(LogicSchema logicSchema, List<Object> parameters) {
        this.logicSchema = logicSchema;
        this.parameters = parameters;
    }
}

