/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.schema;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import org.apache.shardingsphere.api.config.masterslave.MasterSlaveRuleConfiguration;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.metadata.datasource.ShardingDataSourceMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.rule.MasterSlaveRule;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.core.util.ConfigurationLogger;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.MasterSlaveRuleChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import org.apache.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchema;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.config.yaml.YamlDataSourceParameter;

public final class MasterSlaveSchema
extends LogicSchema {
    private MasterSlaveRule masterSlaveRule;
    private final ShardingRule shardingRule;
    private final ShardingMetaData metaData;

    public MasterSlaveSchema(String name, Map<String, YamlDataSourceParameter> dataSources, MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isUsingRegistry) {
        super(name, dataSources);
        this.masterSlaveRule = this.createMasterSlaveRule(masterSlaveRuleConfig, isUsingRegistry);
        this.shardingRule = new ShardingRule(new ShardingRuleConfiguration(), this.getDataSources().keySet());
        this.metaData = this.createShardingMetaData();
    }

    private MasterSlaveRule createMasterSlaveRule(MasterSlaveRuleConfiguration masterSlaveRuleConfig, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationMasterSlaveRule(masterSlaveRuleConfig) : new MasterSlaveRule(masterSlaveRuleConfig);
    }

    private ShardingMetaData createShardingMetaData() {
        ShardingDataSourceMetaData shardingDataSourceMetaData = new ShardingDataSourceMetaData(this.getDataSourceURLs(this.getDataSources()), this.shardingRule, LogicSchemas.getInstance().getDatabaseType());
        ShardingTableMetaData shardingTableMetaData = new ShardingTableMetaData(this.getTableMetaDataInitializer(shardingDataSourceMetaData).load(this.shardingRule));
        return new ShardingMetaData(shardingDataSourceMetaData, shardingTableMetaData);
    }

    @Subscribe
    public synchronized void renew(MasterSlaveRuleChangedEvent masterSlaveRuleChangedEvent) {
        if (this.getName().equals(masterSlaveRuleChangedEvent.getShardingSchemaName())) {
            ConfigurationLogger.log((MasterSlaveRuleConfiguration)masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration());
            this.masterSlaveRule = new OrchestrationMasterSlaveRule(masterSlaveRuleChangedEvent.getMasterSlaveRuleConfiguration());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            ((OrchestrationMasterSlaveRule)this.masterSlaveRule).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
        }
    }

    public MasterSlaveRule getMasterSlaveRule() {
        return this.masterSlaveRule;
    }

    @Override
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

