/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.admin;

import java.beans.ConstructorProperties;
import java.util.LinkedList;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;

public final class BroadcastBackendHandler
implements TextProtocolBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final String sql;
    private final BackendConnection backendConnection;

    @Override
    public BackendResponse execute() {
        LinkedList<BackendResponse> responses = new LinkedList<BackendResponse>();
        String originalSchema = this.backendConnection.getSchemaName();
        for (String string : LogicSchemas.getInstance().getSchemaNames()) {
            this.backendConnection.setCurrentSchema(string);
            responses.add(this.databaseCommunicationEngineFactory.newTextProtocolInstance(LogicSchemas.getInstance().getLogicSchema(string), this.sql, this.backendConnection).execute());
        }
        this.backendConnection.setCurrentSchema(originalSchema);
        for (BackendResponse backendResponse : responses) {
            if (!(backendResponse instanceof ErrorResponse)) continue;
            return backendResponse;
        }
        return new UpdateResponse();
    }

    @Override
    public boolean next() {
        return false;
    }

    @Override
    public QueryData getQueryData() {
        return null;
    }

    @ConstructorProperties(value={"sql", "backendConnection"})
    public BroadcastBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

