/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.query;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngine;
import org.apache.shardingsphere.shardingproxy.backend.communication.DatabaseCommunicationEngineFactory;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.exception.NoDatabaseSelectedException;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;

public final class QueryBackendHandler
implements TextProtocolBackendHandler {
    private final DatabaseCommunicationEngineFactory databaseCommunicationEngineFactory = DatabaseCommunicationEngineFactory.getInstance();
    private final String sql;
    private final BackendConnection backendConnection;
    private DatabaseCommunicationEngine databaseCommunicationEngine;

    @Override
    public BackendResponse execute() {
        if (null == this.backendConnection.getLogicSchema()) {
            return new ErrorResponse(new NoDatabaseSelectedException());
        }
        this.databaseCommunicationEngine = this.databaseCommunicationEngineFactory.newTextProtocolInstance(this.backendConnection.getLogicSchema(), this.sql, this.backendConnection);
        return this.databaseCommunicationEngine.execute();
    }

    @Override
    public boolean next() throws SQLException {
        return this.databaseCommunicationEngine.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        return this.databaseCommunicationEngine.getQueryData();
    }

    @ConstructorProperties(value={"sql", "backendConnection"})
    public QueryBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

