/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.explain;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.wrapper.StatementExecutorWrapper;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.schema.LogicSchemas;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.InvalidShardingCTLFormatException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.explain.ShardingCTLExplainParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.explain.ShardingCTLExplainStatement;

public final class ShardingCTLExplainBackendHandler
implements TextProtocolBackendHandler {
    private final String sql;
    private final BackendConnection backendConnection;
    private List<QueryHeader> queryHeaders;
    private Iterator<RouteUnit> routeUnits;

    @Override
    public BackendResponse execute() {
        Optional<ShardingCTLExplainStatement> explainStatement = new ShardingCTLExplainParser(this.sql).doParse();
        if (!explainStatement.isPresent()) {
            return new ErrorResponse(new InvalidShardingCTLFormatException(this.sql));
        }
        StatementExecutorWrapper statementExecutorWrapper = new StatementExecutorWrapper(this.backendConnection.getLogicSchema());
        this.routeUnits = statementExecutorWrapper.route(((ShardingCTLExplainStatement)explainStatement.get()).getSql(), LogicSchemas.getInstance().getDatabaseType()).getRouteUnits().iterator();
        this.queryHeaders = new ArrayList<QueryHeader>(2);
        this.queryHeaders.add(new QueryHeader("", "", "datasource_name", "", 255, 1, 0));
        this.queryHeaders.add(new QueryHeader("", "", "sql", "", 255, 1, 0));
        return new QueryResponse(this.queryHeaders);
    }

    @Override
    public boolean next() {
        return null != this.routeUnits && this.routeUnits.hasNext();
    }

    @Override
    public QueryData getQueryData() {
        RouteUnit routeUnit = this.routeUnits.next();
        ArrayList<Object> row = new ArrayList<Object>(this.queryHeaders.size());
        row.add(routeUnit.getDataSourceName());
        row.add(routeUnit.getSqlUnit().getSql());
        ArrayList<Integer> columnTypes = new ArrayList<Integer>(this.queryHeaders.size());
        columnTypes.add(this.queryHeaders.get(0).getColumnType());
        columnTypes.add(this.queryHeaders.get(1).getColumnType());
        return new QueryData(columnTypes, row);
    }

    @ConstructorProperties(value={"sql", "backendConnection"})
    public ShardingCTLExplainBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql;
        this.backendConnection = backendConnection;
    }
}

