/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.set;

import com.google.common.base.Optional;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.update.UpdateResponse;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.InvalidShardingCTLFormatException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.UnsupportedShardingCTLTypeException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.set.ShardingCTLSetParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.set.ShardingCTLSetStatement;
import org.apache.shardingsphere.transaction.core.TransactionType;

public final class ShardingCTLSetBackendHandler
implements TextProtocolBackendHandler {
    private final String sql;
    private final BackendConnection backendConnection;

    public ShardingCTLSetBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql.toUpperCase().trim();
        this.backendConnection = backendConnection;
    }

    @Override
    public BackendResponse execute() {
        Optional<ShardingCTLSetStatement> shardingTCLStatement = new ShardingCTLSetParser(this.sql).doParse();
        if (!shardingTCLStatement.isPresent()) {
            return new ErrorResponse(new InvalidShardingCTLFormatException(this.sql));
        }
        switch (((ShardingCTLSetStatement)shardingTCLStatement.get()).getKey()) {
            case "TRANSACTION_TYPE": {
                try {
                    this.backendConnection.setTransactionType(TransactionType.valueOf((String)((ShardingCTLSetStatement)shardingTCLStatement.get()).getValue()));
                    break;
                }
                catch (IllegalArgumentException ex) {
                    return new ErrorResponse(new UnsupportedShardingCTLTypeException(this.sql));
                }
            }
            default: {
                return new ErrorResponse(new UnsupportedShardingCTLTypeException(this.sql));
            }
        }
        return new UpdateResponse();
    }

    @Override
    public boolean next() {
        return false;
    }

    @Override
    public QueryData getQueryData() {
        return null;
    }
}

