/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.backend.text.sctl.show;

import com.google.common.base.Optional;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowShardingCTLMergedResult;
import org.apache.shardingsphere.shardingproxy.backend.communication.jdbc.connection.BackendConnection;
import org.apache.shardingsphere.shardingproxy.backend.response.BackendResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.error.ErrorResponse;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryData;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryHeader;
import org.apache.shardingsphere.shardingproxy.backend.response.query.QueryResponse;
import org.apache.shardingsphere.shardingproxy.backend.text.TextProtocolBackendHandler;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.InvalidShardingCTLFormatException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.exception.UnsupportedShardingCTLTypeException;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.show.ShardingCTLShowParser;
import org.apache.shardingsphere.shardingproxy.backend.text.sctl.show.ShardingCTLShowStatement;

public final class ShardingCTLShowBackendHandler
implements TextProtocolBackendHandler {
    private final String sql;
    private final BackendConnection backendConnection;
    private MergedResult mergedResult;

    public ShardingCTLShowBackendHandler(String sql, BackendConnection backendConnection) {
        this.sql = sql.toUpperCase().trim();
        this.backendConnection = backendConnection;
    }

    @Override
    public BackendResponse execute() {
        Optional<ShardingCTLShowStatement> showStatement = new ShardingCTLShowParser(this.sql).doParse();
        if (!showStatement.isPresent()) {
            return new ErrorResponse(new InvalidShardingCTLFormatException(this.sql));
        }
        switch (((ShardingCTLShowStatement)showStatement.get()).getValue()) {
            case "TRANSACTION_TYPE": {
                return this.createResponsePackets("TRANSACTION_TYPE", this.backendConnection.getTransactionType().name());
            }
            case "CACHED_CONNECTIONS": {
                return this.createResponsePackets("CACHED_CONNECTIONS", this.backendConnection.getConnectionSize());
            }
        }
        return new ErrorResponse(new UnsupportedShardingCTLTypeException(this.sql));
    }

    private BackendResponse createResponsePackets(String columnName, Object ... values) {
        this.mergedResult = new ShowShardingCTLMergedResult(Arrays.asList(values));
        return new QueryResponse(Collections.singletonList(new QueryHeader("", "", columnName, columnName, 100, 12, 0)));
    }

    @Override
    public boolean next() throws SQLException {
        return null != this.mergedResult && this.mergedResult.next();
    }

    @Override
    public QueryData getQueryData() throws SQLException {
        return new QueryData(Collections.singletonList(12), Collections.singletonList(this.mergedResult.getValue(1, Object.class)));
    }
}

