/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingproxy.context;

import com.google.common.eventbus.Subscribe;
import java.util.Properties;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.rule.Authentication;
import org.apache.shardingsphere.core.util.ConfigurationLogger;
import org.apache.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.AuthenticationChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.config.event.PropertiesChangedEvent;
import org.apache.shardingsphere.orchestration.internal.registry.state.event.CircuitStateChangedEvent;

public final class ShardingProxyContext {
    private static final ShardingProxyContext INSTANCE = new ShardingProxyContext();
    private ShardingProperties shardingProperties = new ShardingProperties(new Properties());
    private Authentication authentication;
    private boolean isCircuitBreak;

    private ShardingProxyContext() {
        ShardingOrchestrationEventBus.getInstance().register((Object)this);
    }

    public static ShardingProxyContext getInstance() {
        return INSTANCE;
    }

    public void init(Authentication authentication, Properties props) {
        this.authentication = authentication;
        this.shardingProperties = new ShardingProperties(props);
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        ConfigurationLogger.log((Properties)event.getProps());
        this.shardingProperties = new ShardingProperties(event.getProps());
    }

    @Subscribe
    public synchronized void renew(AuthenticationChangedEvent event) {
        ConfigurationLogger.log((Authentication)event.getAuthentication());
        this.authentication = event.getAuthentication();
    }

    @Subscribe
    public synchronized void renew(CircuitStateChangedEvent event) {
        this.isCircuitBreak = event.isCircuitBreak();
    }

    public ShardingProperties getShardingProperties() {
        return this.shardingProperties;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public boolean isCircuitBreak() {
        return this.isCircuitBreak;
    }
}

