/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core.rule.registry.statement;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.shardingsphere.sql.parser.core.extractor.api.SQLSegmentExtractor;
import org.apache.shardingsphere.sql.parser.core.rule.jaxb.entity.statement.SQLStatementRuleEntity;
import org.apache.shardingsphere.sql.parser.core.rule.registry.extractor.ExtractorRuleDefinition;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class SQLStatementRule {
    private final String contextName;
    private final Class<? extends SQLStatement> sqlStatementClass;
    private final Collection<SQLSegmentExtractor> extractors;

    public SQLStatementRule(SQLStatementRuleEntity entity, ExtractorRuleDefinition extractorRuleDefinition) {
        this.contextName = entity.getContext();
        this.sqlStatementClass = Class.forName(entity.getSqlStatementClass());
        this.extractors = this.getExtractors(entity.getExtractorRuleRefs(), extractorRuleDefinition);
    }

    private Collection<SQLSegmentExtractor> getExtractors(String extractorRuleRefs, ExtractorRuleDefinition extractorRuleDefinition) {
        if (null == extractorRuleRefs) {
            return Collections.emptyList();
        }
        LinkedList<SQLSegmentExtractor> result = new LinkedList<SQLSegmentExtractor>();
        for (String each : Splitter.on((char)',').trimResults().splitToList((CharSequence)extractorRuleRefs)) {
            result.add(extractorRuleDefinition.getExtractor(each));
        }
        return result;
    }

    public String getContextName() {
        return this.contextName;
    }

    public Class<? extends SQLStatement> getSqlStatementClass() {
        return this.sqlStatementClass;
    }

    public Collection<SQLSegmentExtractor> getExtractors() {
        return this.extractors;
    }
}

