/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.clustering.LDAParams$class;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Ue!B\u0001\u0003\u0003Ci!\u0001\u0003'E\u00036{G-\u001a7\u000b\u0005\r!\u0011AC2mkN$XM]5oO*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002F\f\u001c!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003'UI!A\u0006\u0002\u0003\u00131#\u0015\tU1sC6\u001c\bC\u0001\r\u001a\u001b\u00051\u0011B\u0001\u000e\u0007\u0005\u001daunZ4j]\u001e\u0004\"\u0001H\u0010\u000e\u0003uQ!A\b\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003Au\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!\u0011\u0003A!b\u0001\n\u0003\u001a\u0013aA;jIV\tA\u0005\u0005\u0002&W9\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\rM#(/\u001b8h\u0015\tQs\u0005K\u0002\"_U\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00025c\t)1+\u001b8dK\u0006\na'A\u00032]Yr\u0003\u0007\u0003\u00059\u0001\t\u0005\t\u0015!\u0003%\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007]zS\u0007\u0003\u0005<\u0001\t\u0015\r\u0011\"\u0001=\u0003%1xnY1c'&TX-F\u0001>!\t1c(\u0003\u0002@O\t\u0019\u0011J\u001c;)\u0007izS\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003>\u0003)1xnY1c'&TX\r\t\u0015\u0004\u0003>*\u0004\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0003$\u0002\u0015M\fHnQ8oi\u0016DH/F\u0001H!\tA5*D\u0001J\u0015\tQe!A\u0002tc2L!\u0001T%\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fK\u0002E_UB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006IaR\u0001\fgFd7i\u001c8uKb$\b\u0005\u000b\u0002O#B\u0011aEU\u0005\u0003'\u001e\u0012\u0011\u0002\u001e:b]NLWM\u001c;)\u00079{S\u0007\u0003\u0004W\u0001\u0011\u0005AaV\u0001\u0007y%t\u0017\u000e\u001e \u0015\tIA&\f\u0018\u0005\u0006EU\u0003\r\u0001\n\u0015\u00041>*\u0004\"B\u001eV\u0001\u0004i\u0004f\u0001.0k!)Q)\u0016a\u0001\u000f\"\u001aAlL\u001b\t\u000b}\u0003a\u0011\u00031\u0002\u001b=dG\rT8dC2lu\u000eZ3m+\u0005\t\u0007C\u00012g\u001b\u0005\u0019'BA\u0002e\u0015\t)g!A\u0003nY2L'-\u0003\u0002hG\niAj\\2bY2#\u0015)T8eK2D3AX\u00186\u0011\u0015Q\u0007A\"\u0005l\u0003!9W\r^'pI\u0016dW#\u00017\u0011\u0005\tl\u0017BA\u0001dQ\rIw&\u000e\u0005\u0006a\u0002!\t!]\u0001\u000fg\u0016$h)Z1ukJ,7oQ8m)\t\u00118/D\u0001\u0001\u0011\u0015!x\u000e1\u0001%\u0003\u00151\u0018\r\\;fQ\ryw&\u000e\u0005\u0006o\u0002!\t\u0001_\u0001\bg\u0016$8+Z3e)\t\u0011\u0018\u0010C\u0003um\u0002\u0007!\u0010\u0005\u0002'w&\u0011Ap\n\u0002\u0005\u0019>tw\rK\u0002w_UBaa \u0001\u0005B\u0005\u0005\u0011!\u0003;sC:\u001chm\u001c:n)\u0011\t\u0019!!\u0003\u0011\u0007!\u000b)!C\u0002\u0002\b%\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\t\u000f\u0005-a\u00101\u0001\u0002\u0004\u00059A-\u0019;bg\u0016$\bf\u0001@0k!9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0011a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005U\u0011\u0011\u0005\t\u0005\u0003/\ti\"\u0004\u0002\u0002\u001a)\u0019\u00111D%\u0002\u000bQL\b/Z:\n\t\u0005}\u0011\u0011\u0004\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002CA\u0012\u0003\u001f\u0001\r!!\u0006\u0002\rM\u001c\u0007.Z7bQ\u0011\tyaL\u001b\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005IRm\u001d;j[\u0006$X\r\u001a#pG\u000e{gnY3oiJ\fG/[8o+\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019\u0004Z\u0001\u0007Y&t\u0017\r\\4\n\t\u0005]\u0012\u0011\u0007\u0002\u0007-\u0016\u001cGo\u001c:)\t\u0005\u001dr&\u000e\u0005\b\u0003{\u0001A\u0011AA \u00031!x\u000e]5dg6\u000bGO]5y+\t\t\t\u0005\u0005\u0003\u00020\u0005\r\u0013\u0002BA#\u0003c\u0011a!T1ue&D\b\u0006BA\u001e_UBq!a\u0013\u0001\r\u0003\ti%A\u0007jg\u0012K7\u000f\u001e:jEV$X\rZ\u000b\u0003\u0003\u001f\u00022AJA)\u0013\r\t\u0019f\n\u0002\b\u0005>|G.Z1oQ\u0011\tIeL\u001b\t\u000f\u0005e\u0003\u0001\"\u0001\u0002\\\u0005iAn\\4MS.,G.\u001b5p_\u0012$B!!\u0018\u0002dA\u0019a%a\u0018\n\u0007\u0005\u0005tE\u0001\u0004E_V\u0014G.\u001a\u0005\t\u0003\u0017\t9\u00061\u0001\u0002\u0004!\"\u0011qK\u00186\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\nQ\u0002\\8h!\u0016\u0014\b\u000f\\3ySRLH\u0003BA/\u0003[B\u0001\"a\u0003\u0002h\u0001\u0007\u00111\u0001\u0015\u0005\u0003OzS\u0007C\u0004\u0002t\u0001!\t!!\u001e\u0002\u001d\u0011,7o\u0019:jE\u0016$v\u000e]5dgR!\u00111AA<\u0011\u001d\tI(!\u001dA\u0002u\n\u0001#\\1y)\u0016\u0014Xn\u001d)feR{\u0007/[2)\t\u0005Et&\u000e\u0005\b\u0003g\u0002A\u0011AA@)\t\t\u0019\u0001\u000b\u0003\u0002~=*\u0014&\u0002\u0001\u0002\u0006\u0006%\u0015bAAD\u0005\t\u0019B)[:ue&\u0014W\u000f^3e\u0019\u0012\u000bUj\u001c3fY&\u0011qM\u0001\u0015\u0004\u0001\u00055\u0005c\u0001\u0019\u0002\u0010&\u0019\u0011\u0011S\u0019\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u0001yS\u0007")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SQLContext sqlContext;
    private final IntParam k;
    private final DoubleArrayParam docConcentration;
    private final DoubleParam topicConcentration;
    private final String[] supportedOptimizers;
    private final Param<String> optimizer;
    private final Param<String> topicDistributionCol;
    private final DoubleParam learningOffset;
    private final DoubleParam learningDecay;
    private final DoubleParam subsamplingRate;
    private final BooleanParam optimizeDocConcentration;
    private final IntParam checkpointInterval;
    private final LongParam seed;
    private final IntParam maxIter;
    private final Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public int getK() {
        return LDAParams$class.getK(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams$class.getDocConcentration(this);
    }

    @Override
    public Vector getOldDocConcentration() {
        return LDAParams$class.getOldDocConcentration(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams$class.getTopicConcentration(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams$class.getOldTopicConcentration(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams$class.getOptimizer(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams$class.getTopicDistributionCol(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams$class.getLearningOffset(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams$class.getLearningDecay(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams$class.getSubsamplingRate(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams$class.getOptimizeDocConcentration(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public void validateParams() {
        LDAParams$class.validateParams(this);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams$class.getOldOptimizer(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        DataFrame dataFrame;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
                }
            }
            UserDefinedFunction t = functions$.MODULE$.udf(this.oldLocalModel().getTopicDistributionMethod(this.sqlContext().sparkContext()), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(this)));
            dataFrame = dataset.withColumn(this.$(this.topicDistributionCol()), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "LDAModel.transform was called without any output columns. Set an output column such as topicDistributionCol to produce results.";
                }
            });
            dataFrame = dataset;
        }
        return dataFrame;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public Vector estimatedDocConcentration() {
        return this.getModel().docConcentration();
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(DataFrame dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(DataFrame dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public DataFrame describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Seq<Object>, Seq<Object>> apply(Tuple2<Tuple2<int[], double[]>, Object> x0$1) {
                Tuple2<Tuple2<int[], double[]>, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int topic = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        int[] termIndices = (int[])tuple22._1();
                        double[] termWeights = (double[])tuple22._2();
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)Predef$.MODULE$.intArrayOps(termIndices).toSeq(), (Object)Predef$.MODULE$.doubleArrayOps(termWeights).toSeq());
                        return tuple3;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor()}))), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor()})))})));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(LDAModel $outer) {
            }
        }
        return this.sqlContext().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public DataFrame describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SQLContext sqlContext) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sqlContext = sqlContext;
        HasFeaturesCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasSeed$class.$init$(this);
        HasCheckpointInterval$class.$init$(this);
        LDAParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }
}

