/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.param.shared.HasRawPredictionCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001B\u0001\u0003\u00015\u0011QDQ5oCJL8\t\\1tg&4\u0017nY1uS>tWI^1mk\u0006$xN\u001d\u0006\u0003\u0007\u0011\t!\"\u001a<bYV\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001q!CG\u000f\u0011\u0005=\u0001R\"\u0001\u0002\n\u0005E\u0011!!C#wC2,\u0018\r^8s!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004tQ\u0006\u0014X\r\u001a\u0006\u0003/\u0011\tQ\u0001]1sC6L!!\u0007\u000b\u0003'!\u000b7OU1x!J,G-[2uS>t7i\u001c7\u0011\u0005MY\u0012B\u0001\u000f\u0015\u0005-A\u0015m\u001d'bE\u0016d7i\u001c7\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001\"\u0011\u0001B;uS2L!AI\u0010\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\"AA\u0005\u0001BC\u0002\u0013\u0005S%A\u0002vS\u0012,\u0012A\n\t\u0003O5r!\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\na\u0001\u0015:fI\u00164\u0017B\u0001\u00180\u0005\u0019\u0019FO]5oO*\u0011A&\u000b\u0015\u0004GE:\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0003mM\u0012QaU5oG\u0016\f\u0013\u0001O\u0001\u0006c9\"d\u0006\r\u0005\tu\u0001\u0011\t\u0011)A\u0005M\u0005!Q/\u001b3!Q\rI\u0014g\u000e\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\u0002\u0005CA\b\u0001\u0011\u0015!C\b1\u0001'Q\r\u0001\u0015g\u000e\u0015\u0004yE:\u0004\"B\u001f\u0001\t\u0003!E#A )\u0007\r\u000bd)I\u0001H\u0003\u0015\tdF\r\u00181\u0011\u001dI\u0005A1A\u0005\u0002)\u000b!\"\\3ue&\u001cg*Y7f+\u0005Y\u0005c\u0001'NM5\ta#\u0003\u0002O-\t)\u0001+\u0019:b[\"\u001a\u0001*\r$\t\rE\u0003\u0001\u0015!\u0003L\u0003-iW\r\u001e:jG:\u000bW.\u001a\u0011)\u0007A\u000bd\tC\u0003U\u0001\u0011\u0005Q%A\u0007hKRlU\r\u001e:jG:\u000bW.\u001a\u0015\u0004'F2\u0005\"B,\u0001\t\u0003A\u0016!D:fi6+GO]5d\u001d\u0006lW\r\u0006\u0002Z56\t\u0001\u0001C\u0003\\-\u0002\u0007a%A\u0003wC2,X\rK\u0002Wc\u0019CQA\u0018\u0001\u0005\u0002}\u000b1c]3u%\u0006<\bK]3eS\u000e$\u0018n\u001c8D_2$\"!\u00171\t\u000bmk\u0006\u0019\u0001\u0014)\u0007u\u000b$-I\u0001d\u0003\u0015\td&\u000e\u00181\u0011\u0015)\u0007\u0001\"\u0001g\u0003-\u0019X\r^*d_J,7i\u001c7\u0015\u0005e;\u0007\"B.e\u0001\u00041\u0003f\u000132\r\"\"AM[7c!\tA3.\u0003\u0002mS\tQA-\u001a9sK\u000e\fG/\u001a3\"\u00039\fq$^:fAM,GOU1x!J,G-[2uS>t7i\u001c7!S:\u001cH/Z1e\u0011\u0015\u0001\b\u0001\"\u0001r\u0003-\u0019X\r\u001e'bE\u0016d7i\u001c7\u0015\u0005e\u0013\b\"B.p\u0001\u00041\u0003fA82\r\")Q\u000f\u0001C!m\u0006AQM^1mk\u0006$X\r\u0006\u0002xuB\u0011\u0001\u0006_\u0005\u0003s&\u0012a\u0001R8vE2,\u0007\"B>u\u0001\u0004a\u0018a\u00023bi\u0006\u001cX\r\u001e\t\u0004{\u0006\u0005Q\"\u0001@\u000b\u0005}4\u0011aA:rY&\u0019\u00111\u0001@\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007f\u0001;2\r\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0011AD5t\u0019\u0006\u0014x-\u001a:CKR$XM]\u000b\u0003\u0003\u001b\u00012\u0001KA\b\u0013\r\t\t\"\u000b\u0002\b\u0005>|G.Z1oQ\u0011\t9!\r2\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005!1m\u001c9z)\ry\u00141\u0004\u0005\t\u0003;\t)\u00021\u0001\u0002 \u0005)Q\r\u001f;sCB\u0019A*!\t\n\u0007\u0005\rbC\u0001\u0005QCJ\fW.T1qQ\u0015\t)\"MA\u0014C\t\tI#A\u00032]Qr\u0013\u0007K\u0002\u0001\u0003[\u00012AMA\u0018\u0013\r\t\td\r\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0004\u0001E2uaBA\u001c\u0005!\u0005\u0011\u0011H\u0001\u001e\u0005&t\u0017M]=DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8Fm\u0006dW/\u0019;peB\u0019q\"a\u000f\u0007\r\u0005\u0011\u0001\u0012AA\u001f'!\tY$a\u0010\u0002F\u0005-\u0003c\u0001\u0015\u0002B%\u0019\u00111I\u0015\u0003\r\u0005s\u0017PU3g!\u0011q\u0012qI \n\u0007\u0005%sDA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0007!\ni%C\u0002\u0002P%\u0012AbU3sS\u0006d\u0017N_1cY\u0016Dq!PA\u001e\t\u0003\t\u0019\u0006\u0006\u0002\u0002:!A\u0011qKA\u001e\t\u0003\nI&\u0001\u0003m_\u0006$GcA \u0002\\!9\u0011QLA+\u0001\u00041\u0013\u0001\u00029bi\"DS!!\u00162\u0003C\n#!a\u0019\u0002\u000bErcG\f\u0019\t\u0015\u0005\u001d\u00141HA\u0001\n\u0013\tI'A\u0006sK\u0006$'+Z:pYZ,GCAA6!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\nA\u0001\\1oO*\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002z\u0005=$AB(cU\u0016\u001cG\u000fK\u0003\u0002<E\n\t\u0007K\u0003\u00026E\n\t\u0007")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;

    public static MLReader<BinaryClassificationEvaluator> read() {
        return BinaryClassificationEvaluator$.MODULE$.read();
    }

    public static BinaryClassificationEvaluator load(String string) {
        return BinaryClassificationEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol$class.getRawPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public BinaryClassificationEvaluator setRawPredictionCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setScoreCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset) {
        String string;
        block4: {
            double d;
            BinaryClassificationMetrics metrics;
            block3: {
                block2: {
                    StructType schema = dataset.schema();
                    SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.rawPredictionCol()), (DataType)new VectorUDT(), SchemaUtils$.MODULE$.checkColumnType$default$4());
                    SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
                    RDD scoreAndLabels = dataset.select(this.$(this.rawPredictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol())})).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Object> apply(Row x0$1) {
                            Row row = x0$1;
                            Some some = Row$.MODULE$.unapplySeq(row);
                            if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                Object rawPrediction = ((SeqLike)some.get()).apply(0);
                                Object label = ((SeqLike)some.get()).apply(1);
                                if (rawPrediction instanceof Vector) {
                                    Vector vector = (Vector)rawPrediction;
                                    if (label instanceof Double) {
                                        double d = BoxesRunTime.unboxToDouble((Object)label);
                                        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(vector.apply(1), d);
                                        return sp2;
                                    }
                                }
                            }
                            throw new MatchError((Object)row);
                        }
                    }, ClassTag$.MODULE$.apply(Tuple2.class));
                    metrics = new BinaryClassificationMetrics((RDD<Tuple2<Object, Object>>)scoreAndLabels);
                    string = this.$(this.metricName());
                    if (!"areaUnderROC".equals(string)) break block2;
                    d = metrics.areaUnderROC();
                    break block3;
                }
                if (!"areaUnderPR".equals(string)) break block4;
                d = metrics.areaUnderPR();
            }
            double metric = d;
            metrics.unpersist();
            return metric;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public boolean isLargerBetter() {
        String string;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    string = this.$(this.metricName());
                    if (!"areaUnderROC".equals(string)) break block2;
                    bl = true;
                    break block3;
                }
                if (!"areaUnderPR".equals(string)) break block4;
                bl = true;
            }
            return bl;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.defaultCopy(extra);
    }

    public BinaryClassificationEvaluator(String uid) {
        this.uid = uid;
        HasRawPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"areaUnderROC", "areaUnderPR"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("areaUnderROC")}));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binEval"));
    }
}

