/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.ml.regression.GBTRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.GBTRegressor$;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.AbsoluteError$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.loss.SquaredError$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Enumeration;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u00055\u0011Ab\u0012\"U%\u0016<'/Z:t_JT!a\u0001\u0003\u0002\u0015I,wM]3tg&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f?\u0015B\u0003#B\b\u0011%iaR\"\u0001\u0003\n\u0005E!!!\u0003)sK\u0012L7\r^8s!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003\rY+7\r^8s!\tY\u0002!D\u0001\u0003!\tYR$\u0003\u0002\u001f\u0005\t\u0011rI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t\u00013%D\u0001\"\u0015\t\u0011C!\u0001\u0003ue\u0016,\u0017B\u0001\u0013\"\u0005%9%\t\u0016)be\u0006l7\u000f\u0005\u0002!M%\u0011q%\t\u0002\u0014)J,WMU3he\u0016\u001c8o\u001c:QCJ\fWn\u001d\t\u0003S)j\u0011AB\u0005\u0003W\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005.\u0001\t\u0015\r\u0011\"\u0011/\u0003\r)\u0018\u000eZ\u000b\u0002_A\u0011\u0001G\u000e\b\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QGM\u0001\u0007!J,G-\u001a4\n\u0005]B$AB*ue&twM\u0003\u00026e!\u001aAF\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u2\u0011AC1o]>$\u0018\r^5p]&\u0011q\b\u0010\u0002\u0006'&t7-Z\u0011\u0002\u0003\u0006)\u0011G\f\u001b/a!A1\t\u0001B\u0001B\u0003%q&\u0001\u0003vS\u0012\u0004\u0003f\u0001\";\u0001\")a\t\u0001C\u0001\u000f\u00061A(\u001b8jiz\"\"A\u0007%\t\u000b5*\u0005\u0019A\u0018)\u0007!S\u0004\tK\u0002Fu\u0001CQA\u0012\u0001\u0005\u00021#\u0012A\u0007\u0015\u0004\u0017j\u0002\u0005\"B(\u0001\t\u0003\u0002\u0016aC:fi6\u000b\u0007\u0010R3qi\"$\"!\u0015*\u000e\u0003\u0001AQa\u0015(A\u0002Q\u000bQA^1mk\u0016\u0004\"!M+\n\u0005Y\u0013$aA%oi\"\u001aaJ\u000f!\t\u000be\u0003A\u0011\t.\u0002\u0015M,G/T1y\u0005&t7\u000f\u0006\u0002R7\")1\u000b\u0017a\u0001)\"\u001a\u0001L\u000f!\t\u000by\u0003A\u0011I0\u0002-M,G/T5o\u0013:\u001cH/\u00198dKN\u0004VM\u001d(pI\u0016$\"!\u00151\t\u000bMk\u0006\u0019\u0001+)\u0007uS\u0004\tC\u0003d\u0001\u0011\u0005C-\u0001\btKRl\u0015N\\%oM><\u0015-\u001b8\u0015\u0005E+\u0007\"B*c\u0001\u00041\u0007CA\u0019h\u0013\tA'G\u0001\u0004E_V\u0014G.\u001a\u0015\u0004Ej\u0002\u0005\"B6\u0001\t\u0003b\u0017\u0001E:fi6\u000b\u00070T3n_JL\u0018J\\'C)\t\tV\u000eC\u0003TU\u0002\u0007A\u000bK\u0002ku\u0001CQ\u0001\u001d\u0001\u0005BE\fqb]3u\u0007\u0006\u001c\u0007.\u001a(pI\u0016LEm\u001d\u000b\u0003#JDQaU8A\u0002M\u0004\"!\r;\n\u0005U\u0014$a\u0002\"p_2,\u0017M\u001c\u0015\u0004_j\u0002\u0005\"\u0002=\u0001\t\u0003J\u0018!F:fi\u000eCWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\u000b\u0003#jDQaU<A\u0002QC3a\u001e\u001eA\u0011\u0015i\b\u0001\"\u0011\u007f\u0003-\u0019X\r^%naV\u0014\u0018\u000e^=\u0015\u0005E{\b\"B*}\u0001\u0004y\u0003f\u0001?;\u0001\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011AE:fiN+(m]1na2Lgn\u001a*bi\u0016$2!UA\u0005\u0011\u0019\u0019\u00161\u0001a\u0001M\"\"\u00111\u0001\u001eA\u0011\u001d\ty\u0001\u0001C!\u0003#\tqa]3u'\u0016,G\rF\u0002R\u0003'AqaUA\u0007\u0001\u0004\t)\u0002E\u00022\u0003/I1!!\u00073\u0005\u0011auN\\4)\t\u00055!\b\u0011\u0005\b\u0003?\u0001A\u0011IA\u0011\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0004#\u0006\r\u0002BB*\u0002\u001e\u0001\u0007A\u000b\u000b\u0003\u0002\u001ei\u0002\u0005bBA\u0015\u0001\u0011\u0005\u00131F\u0001\fg\u0016$8\u000b^3q'&TX\rF\u0002R\u0003[AaaUA\u0014\u0001\u00041\u0007\u0006BA\u0014u\u0001C\u0011\"a\r\u0001\u0005\u0004%\t!!\u000e\u0002\u00111|7o\u001d+za\u0016,\"!a\u000e\u0011\u000b\u0005e\u0012qH\u0018\u000e\u0005\u0005m\"bAA\u001f\t\u0005)\u0001/\u0019:b[&!\u0011\u0011IA\u001e\u0005\u0015\u0001\u0016M]1nQ\u0011\t\tD\u000f!\t\u0011\u0005\u001d\u0003\u0001)A\u0005\u0003o\t\u0011\u0002\\8tgRK\b/\u001a\u0011)\t\u0005\u0015#\b\u0011\u0005\b\u0003\u001b\u0002A\u0011AA(\u0003-\u0019X\r\u001e'pgN$\u0016\u0010]3\u0015\u0007E\u000b\t\u0006\u0003\u0004T\u0003\u0017\u0002\ra\f\u0015\u0005\u0003\u0017R\u0004\t\u0003\u0004\u0002X\u0001!\tAL\u0001\fO\u0016$Hj\\:t)f\u0004X\r\u000b\u0003\u0002Vi\u0002\u0005\u0002CA/\u0001\u0011\u0005C!a\u0018\u0002\u001d\u001d,Go\u00147e\u0019>\u001c8\u000fV=qKV\u0011\u0011\u0011\r\t\u0005\u0003G\nY'\u0004\u0002\u0002f)!\u0011qMA5\u0003\u0011awn]:\u000b\u0005\t2\u0012\u0002BA7\u0003K\u0012A\u0001T8tg\"9\u0011\u0011\u000f\u0001\u0005R\u0005M\u0014!\u0002;sC&tGc\u0001\u000f\u0002v!A\u0011qOA8\u0001\u0004\tI(A\u0004eCR\f7/\u001a;\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a \u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003\u0007\u000biHA\u0005ECR\fgI]1nK\"9\u0011q\u0011\u0001\u0005B\u0005%\u0015\u0001B2paf$2AGAF\u0011!\ti)!\"A\u0002\u0005=\u0015!B3yiJ\f\u0007\u0003BA\u001d\u0003#KA!a%\u0002<\tA\u0001+\u0019:b[6\u000b\u0007\u000f\u000b\u0003\u0002\u0006j\u0002\u0005f\u0001\u0001\u0002\u001aB\u00191(a'\n\u0007\u0005uEH\u0001\u0007FqB,'/[7f]R\fG\u000eK\u0002\u0001u\u0001;q!a)\u0003\u0011\u0003\t)+\u0001\u0007H\u0005R\u0013Vm\u001a:fgN|'\u000fE\u0002\u001c\u0003O3a!\u0001\u0002\t\u0002\u0005%6CBAT\u0003W\u000b\t\fE\u00022\u0003[K1!a,3\u0005\u0019\te.\u001f*fMB\u0019\u0011'a-\n\u0007\u0005U&G\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004G\u0003O#\t!!/\u0015\u0005\u0005\u0015\u0006BCA_\u0003O\u0013\r\u0011\"\u0002\u0002@\u0006\u00112/\u001e9q_J$X\r\u001a'pgN$\u0016\u0010]3t+\t\t\t\r\u0005\u00032\u0003\u0007|\u0013bAAce\t)\u0011I\u001d:bs\"\"\u00111\u0018\u001eA\u0011%\tY-a*!\u0002\u001b\t\t-A\ntkB\u0004xN\u001d;fI2{7o\u001d+za\u0016\u001c\b\u0005\u000b\u0003\u0002Jj\u0002\u0005BCAi\u0003O\u000b\t\u0011\"\u0003\u0002T\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t)\u000e\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\t1\fgn\u001a\u0006\u0003\u0003?\fAA[1wC&!\u00111]Am\u0005\u0019y%M[3di\"\"\u0011qUAMQ\u0011\t9K\u000f!)\t\u0005\u0005\u0016\u0011\u0014\u0015\u0005\u0003CS\u0004\t")
public final class GBTRegressor
extends Predictor<Vector, GBTRegressor, GBTRegressionModel>
implements GBTParams,
TreeRegressorParams {
    private final String uid;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static String[] supportedLossTypes() {
        return GBTRegressor$.MODULE$.supportedLossTypes();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public void validateParams() {
        GBTParams$class.validateParams(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GBTRegressor setMaxDepth(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public GBTRegressor setMaxBins(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public GBTRegressor setMinInstancesPerNode(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public GBTRegressor setMinInfoGain(double value) {
        return (GBTRegressor)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public GBTRegressor setMaxMemoryInMB(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public GBTRegressor setCacheNodeIds(boolean value) {
        return (GBTRegressor)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public GBTRegressor setCheckpointInterval(int value) {
        return (GBTRegressor)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public GBTRegressor setImpurity(String value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTRegressor.setImpurity should NOT be used";
            }
        });
        return this;
    }

    @Override
    public GBTRegressor setSubsamplingRate(double value) {
        return (GBTRegressor)TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public GBTRegressor setSeed(long value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The 'seed' parameter is currently ignored by Gradient Boosting.";
            }
        });
        return (GBTRegressor)DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public GBTRegressor setMaxIter(int value) {
        return (GBTRegressor)GBTParams$class.setMaxIter(this, value);
    }

    @Override
    public GBTRegressor setStepSize(double value) {
        return (GBTRegressor)GBTParams$class.setStepSize(this, value);
    }

    public Param<String> lossType() {
        return this.lossType;
    }

    public GBTRegressor setLossType(String value) {
        return (GBTRegressor)this.set(this.lossType(), value);
    }

    public String getLossType() {
        return this.$(this.lossType()).toLowerCase();
    }

    @Override
    public Loss getOldLossType() {
        block4: {
            Loss loss2;
            block3: {
                String string;
                block2: {
                    string = this.getLossType();
                    if (!"squared".equals(string)) break block2;
                    loss2 = SquaredError$.MODULE$;
                    break block3;
                }
                if (!"absolute".equals(string)) break block4;
                loss2 = AbsoluteError$.MODULE$;
            }
            return loss2;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTRegressorParams was given bad loss type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getLossType()})));
    }

    @Override
    public GBTRegressionModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
        BoostingStrategy boostingStrategy = GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, Algo$.MODULE$.Regression());
        GradientBoostedTrees oldGBT = new GradientBoostedTrees(boostingStrategy);
        GradientBoostedTreesModel oldModel = oldGBT.run(oldDataset);
        return GBTRegressionModel$.MODULE$.fromOld(oldModel, this, categoricalFeatures, numFeatures);
    }

    @Override
    public GBTRegressor copy(ParamMap extra) {
        return (GBTRegressor)this.defaultCopy(extra);
    }

    public GBTRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
        this.lossType = new Param(this, "lossType", new StringBuilder().append((Object)"Loss function which GBT tries to minimize (case-insensitive). Supported options:").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])GBTRegressor$.MODULE$.supportedLossTypes()).mkString(", ")}))).toString(), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String value) {
                return Predef$.MODULE$.refArrayOps((Object[])GBTRegressor$.MODULE$.supportedLossTypes()).contains((Object)value.toLowerCase());
            }
        });
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.lossType().$minus$greater("squared")}));
    }

    public GBTRegressor() {
        this(Identifiable$.MODULE$.randomUID("gbtr"));
    }
}

