/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.GeneralizedLinearModel$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0002\u00025\u0011acR3oKJ\fG.\u001b>fI2Kg.Z1s\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\t!B]3he\u0016\u001c8/[8o\u0015\t)a!A\u0003nY2L'M\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\bo\u0016Lw\r\u001b;t+\u0005Q\u0002CA\u000e\u001f\u001b\u0005a\"BA\u000f\u0005\u0003\u0019a\u0017N\\1mO&\u0011q\u0004\b\u0002\u0007-\u0016\u001cGo\u001c:)\u0007]\ts\u0005\u0005\u0002#K5\t1E\u0003\u0002%\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0019\u001a#!B*j]\u000e,\u0017%\u0001\u0015\u0002\u000bEr\u0003G\f\u0019\t\u0011)\u0002!\u0011!Q\u0001\ni\t\u0001b^3jO\"$8\u000f\t\u0015\u0004S\u0005:\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u0018\u0002\u0013%tG/\u001a:dKB$X#A\u0018\u0011\u0005=\u0001\u0014BA\u0019\u0011\u0005\u0019!u.\u001e2mK\"\u001aA&I\u001a\"\u0003Q\nQ\u0001\r\u00189]AB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaL\u0001\u000bS:$XM]2faR\u0004\u0003fA\u001b\"g!)\u0011\b\u0001C\u0001u\u00051A(\u001b8jiz\"2aO\u001f@!\ta\u0004!D\u0001\u0003\u0011\u0015A\u0002\b1\u0001\u001bQ\ri\u0014e\n\u0005\u0006[a\u0002\ra\f\u0015\u0004\u007f\u0005\u001a\u0004f\u0001\u001d\"O!)1\t\u0001D\t\t\u0006a\u0001O]3eS\u000e$\bk\\5oiR!q&R$J\u0011\u00151%\t1\u0001\u001b\u0003)!\u0017\r^1NCR\u0014\u0018\u000e\u001f\u0005\u0006\u0011\n\u0003\rAG\u0001\ro\u0016Lw\r\u001b;NCR\u0014\u0018\u000e\u001f\u0005\u0006[\t\u0003\ra\f\u0005\u0006\u0017\u0002!\t\u0001T\u0001\baJ,G-[2u)\ti5\u000bE\u0002O#>j\u0011a\u0014\u0006\u0003!\u001a\t1A\u001d3e\u0013\t\u0011vJA\u0002S\t\u0012CQ\u0001\u0016&A\u0002U\u000b\u0001\u0002^3ti\u0012\u000bG/\u0019\t\u0004\u001dFS\u0002f\u0001&\"O!)1\n\u0001C\u00011R\u0011q&\u0017\u0005\u0006)^\u0003\rA\u0007\u0015\u0004/\u0006:\u0003\"\u0002/\u0001\t\u0003j\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003y\u0003\"a\u00182\u000f\u0005=\u0001\u0017BA1\u0011\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u0004\u0002F\u0001\u0001g!\t\u0011s-\u0003\u0002iG\taA)\u001a<fY>\u0004XM]!qS\"\u001a\u0001!I\u001a")
public abstract class GeneralizedLinearModel
implements Serializable {
    private final Vector weights;
    private final double intercept;

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    public abstract double predictPoint(Vector var1, Vector var2, double var3);

    public RDD<Object> predict(RDD<Vector> testData) {
        Vector localWeights = this.weights();
        Broadcast bcWeights = testData.context().broadcast((Object)localWeights, ClassTag$.MODULE$.apply(Vector.class));
        double localIntercept = this.intercept();
        return testData.mapPartitions((Function1)new Serializable(this, bcWeights, localIntercept){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneralizedLinearModel $outer;
            private final Broadcast bcWeights$1;
            public final double localIntercept$1;

            public final Iterator<Object> apply(Iterator<Vector> iter) {
                Vector w2 = (Vector)this.bcWeights$1.value();
                return iter.map((Function1)new Serializable(this, w2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$predict$1 $outer;
                    private final Vector w$1;

                    public final double apply(Vector v) {
                        return this.$outer.org$apache$spark$mllib$regression$GeneralizedLinearModel$$anonfun$$$outer().predictPoint(v, this.w$1, this.$outer.localIntercept$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.w$1 = w$1;
                    }
                });
            }

            public /* synthetic */ GeneralizedLinearModel org$apache$spark$mllib$regression$GeneralizedLinearModel$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bcWeights$1 = bcWeights$1;
                this.localIntercept$1 = localIntercept$1;
            }
        }, testData.mapPartitions$default$2(), ClassTag$.MODULE$.Double());
    }

    public double predict(Vector testData) {
        return this.predictPoint(testData, this.weights(), this.intercept());
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": intercept = ", ", numFeatures = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getName(), BoxesRunTime.boxToDouble((double)this.intercept()), BoxesRunTime.boxToInteger((int)this.weights().size())}));
    }

    public GeneralizedLinearModel(Vector weights2, double intercept) {
        this.weights = weights2;
        this.intercept = intercept;
    }
}

