/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001B\u0001\u0003\u00015\u0011Ac\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001c(BA\u0002\u0005\u0003\u0011!(/Z3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\r\u000e\u0003\u0019I!A\u0007\u0004\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013%Q$\u0001\tc_>\u001cH/\u001b8h'R\u0014\u0018\r^3hsV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\t\u0011\u0003!\t{wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002#\t|wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0005C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u0002\"A\u000b\u0001\u000e\u0003\tAQ\u0001\b\u0014A\u0002yA3AJ\u00174!\tq\u0013'D\u00010\u0015\t\u0001d!\u0001\u0006b]:|G/\u0019;j_:L!AM\u0018\u0003\u000bMKgnY3\"\u0003Q\nQ!\r\u00183]ABQA\u000e\u0001\u0005\u0002]\n1A];o)\tAd\b\u0005\u0002:y5\t!H\u0003\u0002<\u0005\u0005)Qn\u001c3fY&\u0011QH\u000f\u0002\u001a\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:N_\u0012,G\u000eC\u0003@k\u0001\u0007\u0001)A\u0003j]B,H\u000fE\u0002B\t\u001ak\u0011A\u0011\u0006\u0003\u0007\u001a\t1A\u001d3e\u0013\t)%IA\u0002S\t\u0012\u0003\"a\u0012&\u000e\u0003!S!!\u0013\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002L\u0011\naA*\u00192fY\u0016$\u0007k\\5oi\"\u001aQ'L\u001a\t\u000bY\u0002A\u0011\u0001(\u0015\u0005az\u0005\"B N\u0001\u0004\u0001\u0006cA)W\r6\t!K\u0003\u0002T)\u0006!!.\u0019<b\u0015\t)f!A\u0002ba&L!a\u0016*\u0003\u000f)\u000bg/\u0019*E\t\"\u001aQ*L\u001a\t\u000bi\u0003A\u0011A.\u0002#I,hnV5uQZ\u000bG.\u001b3bi&|g\u000eF\u000299vCQaP-A\u0002\u0001CQAX-A\u0002\u0001\u000bqB^1mS\u0012\fG/[8o\u0013:\u0004X\u000f\u001e\u0015\u000436\u0002\u0017%A1\u0002\u000bErCG\f\u0019\t\u000bi\u0003A\u0011A2\u0015\u0007a\"W\rC\u0003@E\u0002\u0007\u0001\u000bC\u0003_E\u0002\u0007\u0001\u000bK\u0002c[\u0001D3\u0001A\u00174\u000f\u0015I'\u0001#\u0001k\u0003Q9%/\u00193jK:$(i\\8ti\u0016$GK]3fgB\u0011!f\u001b\u0004\u0006\u0003\tA\t\u0001\\\n\u0005W:9B\u0003C\u0003(W\u0012\u0005a\u000eF\u0001k\u0011\u0015\u00018\u000e\"\u0001r\u0003\u0015!(/Y5o)\rA$o\u001d\u0005\u0006\u007f=\u0004\r\u0001\u0011\u0005\u00069=\u0004\rA\b\u0015\u0004_6\u001a\u0004\"\u00029l\t\u00031Hc\u0001\u001dxq\")q(\u001ea\u0001!\")A$\u001ea\u0001=!\u001aQ/L\u001a\t\u000bm\\G\u0011\u0002?\u0002\u000b\t|wn\u001d;\u0015\rajhp`A\u0001\u0011\u0015y$\u00101\u0001A\u0011\u0015q&\u00101\u0001A\u0011\u0015a\"\u00101\u0001\u001f\u0011\u001d\t\u0019A\u001fa\u0001\u0003\u000b\t\u0001B^1mS\u0012\fG/\u001a\t\u0004\u001f\u0005\u001d\u0011bAA\u0005!\t9!i\\8mK\u0006t\u0007\"CA\u0007W\u0006\u0005I\u0011BA\b\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005E\u0001\u0003BA\n\u00037i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u0005Y\u0006twMC\u0001T\u0013\u0011\ti\"!\u0006\u0003\r=\u0013'.Z2uQ\rYWf\r\u0015\u0004Q6\u001a\u0004")
public class GradientBoostedTrees
implements Serializable,
Logging {
    private final BoostingStrategy boostingStrategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GradientBoostedTreesModel train(JavaRDD<LabeledPoint> javaRDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(javaRDD, boostingStrategy);
    }

    public static GradientBoostedTreesModel train(RDD<LabeledPoint> rDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(rDD, boostingStrategy);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private BoostingStrategy boostingStrategy() {
        return this.boostingStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel run(RDD<LabeledPoint> input) {
        void var2_2;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, input, this.boostingStrategy(), false);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedInput, this.boostingStrategy(), false);
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
    }

    public GradientBoostedTreesModel run(JavaRDD<LabeledPoint> input) {
        return this.run((RDD<LabeledPoint>)input.rdd());
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel runWithValidation(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput) {
        void var3_3;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, validationInput, this.boostingStrategy(), true);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD remappedValidationInput = validationInput.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedValidationInput, this.boostingStrategy(), true);
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3})));
    }

    public GradientBoostedTreesModel runWithValidation(JavaRDD<LabeledPoint> input, JavaRDD<LabeledPoint> validationInput) {
        return this.runWithValidation((RDD<LabeledPoint>)input.rdd(), (RDD<LabeledPoint>)validationInput.rdd());
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy) {
        this.boostingStrategy = boostingStrategy;
        Logging.class.$init$((Logging)this);
    }
}

