/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.ClusteringEvaluator$;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasFeaturesCol;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001B\u0001\u0003\u00015\u00111c\u00117vgR,'/\u001b8h\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%ii\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%)e/\u00197vCR|'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"\u0001\u0005%bgB\u0013X\rZ5di&|gnQ8m!\t\u00192$\u0003\u0002\u001d)\tq\u0001*Y:GK\u0006$XO]3t\u0007>d\u0007C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0011)H/\u001b7\n\u0005\tz\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.\u001a\u0005\tI\u0001\u0011)\u0019!C!K\u0005\u0019Q/\u001b3\u0016\u0003\u0019\u0002\"aJ\u0017\u000f\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0002\rA\u0013X\rZ3g\u0013\tqsF\u0001\u0004TiJLgn\u001a\u0006\u0003Y%B3aI\u00198!\t\u0011T'D\u00014\u0015\t!d!\u0001\u0006b]:|G/\u0019;j_:L!AN\u001a\u0003\u000bMKgnY3\"\u0003a\nQA\r\u00184]AB\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0005k&$\u0007\u0005K\u0002:c]BQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDCA A!\ty\u0001\u0001C\u0003%y\u0001\u0007a\u0005K\u0002Ac]B3\u0001P\u00198\u0011\u0015i\u0004\u0001\"\u0001E)\u0005y\u0004fA\"2o!)q\t\u0001C!\u0011\u0006!1m\u001c9z)\ty\u0014\nC\u0003K\r\u0002\u00071*\u0001\u0003q\u001b\u0006\u0004\bC\u0001'N\u001b\u00051\u0012B\u0001(\u0017\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bf\u0001$2o!)\u0011\u000b\u0001C!%\u0006q\u0011n\u001d'be\u001e,'OQ3ui\u0016\u0014X#A*\u0011\u0005!\"\u0016BA+*\u0005\u001d\u0011un\u001c7fC:D3\u0001U\u00198\u0011\u0015A\u0006\u0001\"\u0001Z\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002[76\t\u0001\u0001C\u0003]/\u0002\u0007a%A\u0003wC2,X\rK\u0002Xc]BQa\u0018\u0001\u0005\u0002\u0001\fab]3u\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0006\u0002[C\")AL\u0018a\u0001M!\u001aa,M\u001c\t\u000f\u0011\u0004!\u0019!C\u0001K\u0006QQ.\u001a;sS\u000et\u0015-\\3\u0016\u0003\u0019\u00042\u0001T4'\u0013\tAgCA\u0003QCJ\fW\u000eK\u0002dc]Baa\u001b\u0001!\u0002\u00131\u0017aC7fiJL7MT1nK\u0002B3A[\u00198\u0011\u0015q\u0007\u0001\"\u0001&\u000359W\r^'fiJL7MT1nK\"\u001aQ.M\u001c\t\u000bE\u0004A\u0011\u0001:\u0002\u001bM,G/T3ue&\u001cg*Y7f)\tQ6\u000fC\u0003]a\u0002\u0007a\u0005K\u0002qc]BqA\u001e\u0001C\u0002\u0013\u0005Q-A\beSN$\u0018M\\2f\u001b\u0016\f7/\u001e:fQ\r)\u0018\u0007_\u0011\u0002s\u0006)!G\f\u001b/a!11\u0010\u0001Q\u0001\n\u0019\f\u0001\u0003Z5ti\u0006t7-Z'fCN,(/\u001a\u0011)\u0007i\f\u0004\u0010C\u0003\u007f\u0001\u0011\u0005Q%\u0001\nhKR$\u0015n\u001d;b]\u000e,W*Z1tkJ,\u0007fA?2q\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011AE:fi\u0012K7\u000f^1oG\u0016lU-Y:ve\u0016$2AWA\u0004\u0011\u0019a\u0016\u0011\u0001a\u0001M!\"\u0011\u0011A\u0019y\u0011\u001d\ti\u0001\u0001C!\u0003\u001f\t\u0001\"\u001a<bYV\fG/\u001a\u000b\u0005\u0003#\t9\u0002E\u0002)\u0003'I1!!\u0006*\u0005\u0019!u.\u001e2mK\"A\u0011\u0011DA\u0006\u0001\u0004\tY\"A\u0004eCR\f7/\u001a;1\t\u0005u\u0011Q\u0006\t\u0007\u0003?\t)#!\u000b\u000e\u0005\u0005\u0005\"bAA\u0012\r\u0005\u00191/\u001d7\n\t\u0005\u001d\u0012\u0011\u0005\u0002\b\t\u0006$\u0018m]3u!\u0011\tY#!\f\r\u0001\u0011a\u0011qFA\f\u0003\u0003\u0005\tQ!\u0001\u00022\t\u0019q\fJ\u0019\u0012\t\u0005M\u0012\u0011\b\t\u0004Q\u0005U\u0012bAA\u001cS\t9aj\u001c;iS:<\u0007c\u0001\u0015\u0002<%\u0019\u0011QH\u0015\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u0002\fE:\u0004f\u0001\u00012o!\u001a\u0001!!\u0012\u0011\u0007I\n9%C\u0002\u0002JM\u0012A\"\u0012=qKJLW.\u001a8uC2<q!!\u0014\u0003\u0011\u0003\ty%A\nDYV\u001cH/\u001a:j]\u001e,e/\u00197vCR|'\u000fE\u0002\u0010\u0003#2a!\u0001\u0002\t\u0002\u0005M3\u0003CA)\u0003+\nY&!\u0019\u0011\u0007!\n9&C\u0002\u0002Z%\u0012a!\u00118z%\u00164\u0007\u0003\u0002\u0010\u0002^}J1!a\u0018 \u0005U!UMZ1vYR\u0004\u0016M]1ngJ+\u0017\rZ1cY\u0016\u00042\u0001KA2\u0013\r\t)'\u000b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\b{\u0005EC\u0011AA5)\t\ty\u0005\u0003\u0005\u0002n\u0005EC\u0011IA8\u0003\u0011aw.\u00193\u0015\u0007}\n\t\bC\u0004\u0002t\u0005-\u0004\u0019\u0001\u0014\u0002\tA\fG\u000f\u001b\u0015\u0005\u0003W\nt\u0007\u0003\u0006\u0002z\u0005E\u0013\u0011!C\u0005\u0003w\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0010\t\u0005\u0003\u007f\nI)\u0004\u0002\u0002\u0002*!\u00111QAC\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0015\u0001\u00026bm\u0006LA!a#\u0002\u0002\n1qJ\u00196fGRDC!!\u00152o!\"\u00111J\u00198\u0001")
public class ClusteringEvaluator
extends Evaluator
implements HasPredictionCol,
HasFeaturesCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> distanceMeasure;
    private final Param<String> featuresCol;
    private final Param<String> predictionCol;

    public static MLReader<ClusteringEvaluator> read() {
        return ClusteringEvaluator$.MODULE$.read();
    }

    public static ClusteringEvaluator load(String string) {
        return ClusteringEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public ClusteringEvaluator copy(ParamMap pMap) {
        return (ClusteringEvaluator)this.defaultCopy(pMap);
    }

    @Override
    public boolean isLargerBetter() {
        return true;
    }

    public ClusteringEvaluator setPredictionCol(String value) {
        return (ClusteringEvaluator)this.set(this.predictionCol(), value);
    }

    public ClusteringEvaluator setFeaturesCol(String value) {
        return (ClusteringEvaluator)this.set(this.featuresCol(), value);
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public ClusteringEvaluator setMetricName(String value) {
        return (ClusteringEvaluator)this.set(this.metricName(), value);
    }

    public Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    public String getDistanceMeasure() {
        return this.$(this.distanceMeasure());
    }

    public ClusteringEvaluator setDistanceMeasure(String value) {
        return (ClusteringEvaluator)this.set(this.distanceMeasure(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        Tuple2 tuple2;
        block6: {
            double d;
            block5: {
                Dataset df;
                block4: {
                    SchemaUtils$.MODULE$.validateVectorCompatibleColumn(dataset.schema(), this.$(this.featuresCol()));
                    SchemaUtils$.MODULE$.checkNumericType(dataset.schema(), this.$(this.predictionCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
                    Column vectorCol = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.featuresCol()));
                    df = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), vectorCol.as(this.$(this.featuresCol()), dataset.schema().apply(this.$(this.featuresCol())).metadata())}));
                    tuple2 = new Tuple2((Object)this.$(this.metricName()), (Object)this.$(this.distanceMeasure()));
                    if (tuple2 == null) break block4;
                    String string = (String)tuple2._1();
                    String string2 = (String)tuple2._2();
                    if (!"silhouette".equals(string) || !"squaredEuclidean".equals(string2)) break block4;
                    d = SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
                    break block5;
                }
                if (tuple2 == null) break block6;
                String string = (String)tuple2._1();
                String string3 = (String)tuple2._2();
                if (!"silhouette".equals(string) || !"cosine".equals(string3)) break block6;
                d = CosineSilhouette$.MODULE$.computeSilhouetteScore(df, this.$(this.predictionCol()), this.$(this.featuresCol()));
            }
            return d;
        }
        if (tuple2 != null) {
            String mn = (String)tuple2._1();
            String dm = (String)tuple2._2();
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No support for metric ", ", distance ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mn, dm})));
        }
        throw new MatchError((Object)tuple2);
    }

    public ClusteringEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"silhouette"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (silhouette)", allowedParams);
        String[] availableValues = (String[])((Object[])new String[]{"squaredEuclidean", "cosine"});
        Function1 allowedParams2 = ParamValidators$.MODULE$.inArray(availableValues);
        this.distanceMeasure = new Param(this, "distanceMeasure", new StringBuilder().append((Object)"distance measure in evaluation. Supported options: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])availableValues).mkString("'", "', '", "'")).toString(), allowedParams2);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("silhouette"), this.distanceMeasure().$minus$greater("squaredEuclidean")}));
    }

    public ClusteringEvaluator() {
        this(Identifiable$.MODULE$.randomUID("cluEval"));
    }
}

