/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.deeplearning4j.datasets.fetchers.EmnistDataFetcher;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.BaseDatasetIterator;
import org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher;

public class EmnistDataSetIterator
extends BaseDatasetIterator {
    private static final int NUM_COMPLETE_TRAIN = 697932;
    private static final int NUM_COMPLETE_TEST = 116323;
    private static final int NUM_MERGE_TRAIN = 697932;
    private static final int NUM_MERGE_TEST = 116323;
    private static final int NUM_BALANCED_TRAIN = 112800;
    private static final int NUM_BALANCED_TEST = 18800;
    private static final int NUM_DIGITS_TRAIN = 240000;
    private static final int NUM_DIGITS_TEST = 40000;
    private static final int NUM_LETTERS_TRAIN = 88800;
    private static final int NUM_LETTERS_TEST = 14800;
    private static final int NUM_MNIST_TRAIN = 60000;
    private static final int NUM_MNIST_TEST = 10000;
    private static final char[] LABELS_COMPLETE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] LABELS_MERGE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'd', 'e', 'f', 'g', 'h', 'n', 'q', 'r', 't'};
    private static final char[] LABELS_BALANCED = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'd', 'e', 'f', 'g', 'h', 'n', 'q', 'r', 't'};
    private static final char[] LABELS_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] LABELS_LETTERS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    protected Set dataSet;
    protected int batch;
    protected int numExamples;
    protected DataSetPreProcessor preProcessor;

    public EmnistDataSetIterator(Set dataSet, int batch, boolean train) throws IOException {
        this(dataSet, batch, train, System.currentTimeMillis());
    }

    public EmnistDataSetIterator(Set dataSet, int batchSize, boolean train, long seed) throws IOException {
        this(dataSet, batchSize, false, train, true, seed);
    }

    public EmnistDataSetIterator(Set dataSet, int batch, boolean binarize, boolean train, boolean shuffle, long rngSeed) throws IOException {
        super(batch, EmnistDataSetIterator.numExamples(train, dataSet), (DataSetFetcher)new EmnistDataFetcher(dataSet, binarize, train, shuffle, rngSeed));
        this.dataSet = dataSet;
    }

    private static int numExamples(boolean train, Set ds) {
        if (train) {
            return EmnistDataSetIterator.numExamplesTrain(ds);
        }
        return EmnistDataSetIterator.numExamplesTest(ds);
    }

    public static int numExamplesTrain(Set dataSet) {
        switch (dataSet) {
            case COMPLETE: {
                return 697932;
            }
            case MERGE: {
                return 697932;
            }
            case BALANCED: {
                return 112800;
            }
            case LETTERS: {
                return 88800;
            }
            case DIGITS: {
                return 240000;
            }
            case MNIST: {
                return 60000;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + (Object)((Object)dataSet));
    }

    public static int numExamplesTest(Set dataSet) {
        switch (dataSet) {
            case COMPLETE: {
                return 116323;
            }
            case MERGE: {
                return 116323;
            }
            case BALANCED: {
                return 18800;
            }
            case LETTERS: {
                return 14800;
            }
            case DIGITS: {
                return 40000;
            }
            case MNIST: {
                return 10000;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + (Object)((Object)dataSet));
    }

    public static int numLabels(Set dataSet) {
        switch (dataSet) {
            case COMPLETE: {
                return 62;
            }
            case MERGE: {
                return 47;
            }
            case BALANCED: {
                return 47;
            }
            case LETTERS: {
                return 26;
            }
            case DIGITS: {
                return 10;
            }
            case MNIST: {
                return 10;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + (Object)((Object)dataSet));
    }

    public char[] getLabelsArrays() {
        return EmnistDataSetIterator.getLabelsArray(this.dataSet);
    }

    public List<String> getLabels() {
        return EmnistDataSetIterator.getLabels(this.dataSet);
    }

    public static char[] getLabelsArray(Set dataSet) {
        switch (dataSet) {
            case COMPLETE: {
                return LABELS_COMPLETE;
            }
            case MERGE: {
                return LABELS_MERGE;
            }
            case BALANCED: {
                return LABELS_BALANCED;
            }
            case LETTERS: {
                return LABELS_LETTERS;
            }
            case DIGITS: 
            case MNIST: {
                return LABELS_DIGITS;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + (Object)((Object)dataSet));
    }

    public static List<String> getLabels(Set dataSet) {
        char[] c = EmnistDataSetIterator.getLabelsArray(dataSet);
        ArrayList<String> l = new ArrayList<String>(c.length);
        for (char c2 : c) {
            l.add(String.valueOf(c2));
        }
        return l;
    }

    public static boolean isBalanced(Set dataSet) {
        switch (dataSet) {
            case COMPLETE: 
            case MERGE: 
            case LETTERS: {
                return false;
            }
            case BALANCED: 
            case DIGITS: 
            case MNIST: {
                return true;
            }
        }
        throw new UnsupportedOperationException("Unknown Set: " + (Object)((Object)dataSet));
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    public static enum Set {
        COMPLETE,
        MERGE,
        BALANCED,
        LETTERS,
        DIGITS,
        MNIST;

    }
}

