/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.api;

import java.io.Serializable;

public class WorkerConfiguration
implements Serializable {
    protected final boolean isGraphNetwork;
    protected final int dataSetObjectSizeExamples;
    protected final int batchSizePerWorker;
    protected final int maxBatchesPerWorker;
    protected final int prefetchNumBatches;
    protected final boolean collectTrainingStats;

    public WorkerConfiguration(boolean isGraphNetwork, int dataSetObjectSizeExamples, int batchSizePerWorker, int maxBatchesPerWorker, int prefetchNumBatches, boolean collectTrainingStats) {
        this.isGraphNetwork = isGraphNetwork;
        this.dataSetObjectSizeExamples = dataSetObjectSizeExamples;
        this.batchSizePerWorker = batchSizePerWorker;
        this.maxBatchesPerWorker = maxBatchesPerWorker;
        this.prefetchNumBatches = prefetchNumBatches;
        this.collectTrainingStats = collectTrainingStats;
    }

    public boolean isGraphNetwork() {
        return this.isGraphNetwork;
    }

    public int getDataSetObjectSizeExamples() {
        return this.dataSetObjectSizeExamples;
    }

    public int getBatchSizePerWorker() {
        return this.batchSizePerWorker;
    }

    public int getMaxBatchesPerWorker() {
        return this.maxBatchesPerWorker;
    }

    public int getPrefetchNumBatches() {
        return this.prefetchNumBatches;
    }

    public boolean isCollectTrainingStats() {
        return this.collectTrainingStats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkerConfiguration)) {
            return false;
        }
        WorkerConfiguration other = (WorkerConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGraphNetwork() != other.isGraphNetwork()) {
            return false;
        }
        if (this.getDataSetObjectSizeExamples() != other.getDataSetObjectSizeExamples()) {
            return false;
        }
        if (this.getBatchSizePerWorker() != other.getBatchSizePerWorker()) {
            return false;
        }
        if (this.getMaxBatchesPerWorker() != other.getMaxBatchesPerWorker()) {
            return false;
        }
        if (this.getPrefetchNumBatches() != other.getPrefetchNumBatches()) {
            return false;
        }
        return this.isCollectTrainingStats() == other.isCollectTrainingStats();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkerConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGraphNetwork() ? 79 : 97);
        result = result * 59 + this.getDataSetObjectSizeExamples();
        result = result * 59 + this.getBatchSizePerWorker();
        result = result * 59 + this.getMaxBatchesPerWorker();
        result = result * 59 + this.getPrefetchNumBatches();
        result = result * 59 + (this.isCollectTrainingStats() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "WorkerConfiguration(isGraphNetwork=" + this.isGraphNetwork() + ", dataSetObjectSizeExamples=" + this.getDataSetObjectSizeExamples() + ", batchSizePerWorker=" + this.getBatchSizePerWorker() + ", maxBatchesPerWorker=" + this.getMaxBatchesPerWorker() + ", prefetchNumBatches=" + this.getPrefetchNumBatches() + ", collectTrainingStats=" + this.isCollectTrainingStats() + ")";
    }
}

