/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.impl.common.repartition;

import java.util.Random;
import org.apache.spark.Partitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancedPartitioner
extends Partitioner {
    private static final Logger log = LoggerFactory.getLogger(BalancedPartitioner.class);
    private final int numPartitions;
    private final int elementsPerPartition;
    private final int remainder;
    private Random r;

    public BalancedPartitioner(int numPartitions, int elementsPerPartition, int remainder) {
        this.numPartitions = numPartitions;
        this.elementsPerPartition = elementsPerPartition;
        this.remainder = remainder;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int getPartition(Object key) {
        int elementIdx = key.hashCode();
        if (elementIdx <= (this.elementsPerPartition + 1) * this.remainder) {
            int outputPartition = elementIdx / (this.elementsPerPartition + 1);
            if (outputPartition >= this.numPartitions) {
                outputPartition = this.getRandom().nextInt(this.numPartitions);
                log.trace("Random partition assigned (1): elementIdx={}, numPartitions={}, elementsPerPartition={}, remainder={}", new Object[]{elementIdx, this.numPartitions, this.elementsPerPartition, this.remainder});
            }
            return outputPartition;
        }
        int numValsInLargerPartitions = this.remainder * (this.elementsPerPartition + 1);
        int idxInSmallerPartitions = elementIdx - numValsInLargerPartitions;
        int smallPartitionIdx = idxInSmallerPartitions / this.elementsPerPartition;
        int outputPartition = this.remainder + smallPartitionIdx;
        if (outputPartition >= this.numPartitions) {
            outputPartition = this.getRandom().nextInt(this.numPartitions);
            log.trace("Random partition assigned (2): elementIdx={}, numPartitions={}, elementsPerPartition={}, remainder={}", new Object[]{elementIdx, this.numPartitions, this.elementsPerPartition, this.remainder});
        }
        return outputPartition;
    }

    private synchronized Random getRandom() {
        if (this.r == null) {
            this.r = new Random();
        }
        return this.r;
    }
}

