/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.spark.iterator;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.broadcast.Broadcast;
import org.datavec.spark.util.DefaultHadoopConfig;
import org.datavec.spark.util.SerializableHadoopConfig;
import org.deeplearning4j.api.loader.MultiDataSetLoader;
import org.deeplearning4j.spark.data.loader.RemoteFileSource;
import org.nd4j.api.loader.Source;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class PathSparkMultiDataSetIterator
implements MultiDataSetIterator {
    public static final int BUFFER_SIZE = 0x400000;
    private final Collection<String> dataSetStreams;
    private MultiDataSetPreProcessor preprocessor;
    private Iterator<String> iter;
    private FileSystem fileSystem;
    private final MultiDataSetLoader loader;
    private final Broadcast<SerializableHadoopConfig> hadoopConfig;

    public PathSparkMultiDataSetIterator(Iterator<String> iter, MultiDataSetLoader loader, Broadcast<SerializableHadoopConfig> hadoopConfig) {
        this.dataSetStreams = null;
        this.iter = iter;
        this.loader = loader;
        this.hadoopConfig = hadoopConfig;
    }

    public PathSparkMultiDataSetIterator(Collection<String> dataSetStreams, MultiDataSetLoader loader, Broadcast<SerializableHadoopConfig> hadoopConfig) {
        this.dataSetStreams = dataSetStreams;
        this.iter = dataSetStreams.iterator();
        this.loader = loader;
        this.hadoopConfig = hadoopConfig;
    }

    public MultiDataSet next(int num) {
        return this.next();
    }

    public boolean resetSupported() {
        return this.dataSetStreams != null;
    }

    public boolean asyncSupported() {
        return true;
    }

    public void reset() {
        if (this.dataSetStreams == null) {
            throw new IllegalStateException("Cannot reset iterator constructed with an iterator");
        }
        this.iter = this.dataSetStreams.iterator();
    }

    public void setPreProcessor(MultiDataSetPreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    public MultiDataSetPreProcessor getPreProcessor() {
        return this.preprocessor;
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public MultiDataSet next() {
        MultiDataSet ds = this.load(this.iter.next());
        if (this.preprocessor != null) {
            this.preprocessor.preProcess(ds);
        }
        return ds;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private synchronized MultiDataSet load(String path) {
        if (this.fileSystem == null) {
            try {
                Configuration c = this.hadoopConfig == null ? DefaultHadoopConfig.get() : ((SerializableHadoopConfig)this.hadoopConfig.getValue()).getConfiguration();
                this.fileSystem = FileSystem.get((URI)new URI(path), (Configuration)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (MultiDataSet)this.loader.load((Source)new RemoteFileSource(path, this.fileSystem, 0x400000));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading MultiDataSet at path " + path + " - DataSet may be corrupt or invalid. Spark MultiDataSets can be validated using org.deeplearning4j.spark.util.data.SparkDataValidation", e);
        }
    }
}

