/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.common;

import com.greenpineyu.fel.common.ArrayUtils;
import com.greenpineyu.fel.function.operator.Add;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtil {
    protected static final BigDecimal BIGD_DOUBLE_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE);
    protected static final BigDecimal BIGD_DOUBLE_MIN_VALUE = BigDecimal.valueOf(0L);
    protected static final BigInteger BIGI_LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigInteger BIGI_LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);

    public static boolean toBoolean(Object val) {
        return NumberUtil.toBooleanObj(val);
    }

    public static Boolean toBooleanObj(Object val) {
        if (val == null) {
            return Boolean.FALSE;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            return Boolean.valueOf((String)val);
        }
        return Boolean.FALSE;
    }

    public static int toInteger(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Integer coercion exception. arg is null");
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0;
            }
            return Integer.parseInt((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Integer coercion exception");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new IllegalArgumentException("Integer coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static long toLong(Object val) {
        if (val == null) {
            throw new NumberFormatException("Long coercion exception. arg is null");
        }
        if (val instanceof String) {
            if ("".equals(val)) {
                return 0L;
            }
            return Long.parseLong((String)val);
        }
        if (val instanceof Character) {
            return ((Character)val).charValue();
        }
        if (val instanceof Boolean) {
            throw new NumberFormatException("Boolean->Long coercion exception");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        throw new NumberFormatException("Long coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static BigInteger toBigInteger(Object val) {
        if (val instanceof BigInteger) {
            return (BigInteger)val;
        }
        if (val == null) {
            throw new IllegalArgumentException("BigInteger coercion exception. arg is null");
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return BigInteger.ZERO;
            }
            return new BigInteger(string);
        }
        if (val instanceof Number) {
            return new BigInteger(val.toString());
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return BigInteger.valueOf(i);
        }
        throw new IllegalArgumentException("BigInteger coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static BigDecimal toBigDecimal(Object val) {
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        if (val == null) {
            throw new IllegalArgumentException("BigDecimal coercion exception. arg is null");
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(string);
        }
        if (val instanceof Number) {
            return new BigDecimal(val.toString());
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return new BigDecimal(i);
        }
        throw new IllegalArgumentException("BigDecimal coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static double toDouble(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("Double coercion exception. arg is null");
        }
        if (val instanceof String) {
            String string = (String)val;
            if ("".equals(string.trim())) {
                return 0.0;
            }
            return Double.parseDouble(string);
        }
        if (val instanceof Character) {
            char i = ((Character)val).charValue();
            return i;
        }
        if (val instanceof Number) {
            return NumberUtil.toDouble((Number)val);
        }
        if (val instanceof Boolean) {
            throw new IllegalArgumentException("Boolean->Double coercion exception");
        }
        throw new IllegalArgumentException("Double coercion exception. Can't coerce type: " + val.getClass().getName());
    }

    public static Number narrow(Number original) {
        BigDecimal bigd;
        if (original == null) {
            return original;
        }
        Number result = original;
        if (original instanceof BigDecimal && (bigd = (BigDecimal)original).compareTo(BIGD_DOUBLE_MAX_VALUE) > 0) {
            return original;
        }
        if (original instanceof Double || original instanceof Float || original instanceof BigDecimal) {
            double value = original.doubleValue();
            if (value <= 3.4028234663852886E38 && value >= (double)1.4E-45f) {
                result = Float.valueOf(String.valueOf(result.floatValue()));
            }
        } else {
            BigInteger bigi;
            if (original instanceof BigInteger && ((bigi = (BigInteger)original).compareTo(BIGI_LONG_MAX_VALUE) > 0 || bigi.compareTo(BIGI_LONG_MIN_VALUE) < 0)) {
                return original;
            }
            long value = original.longValue();
            if (value <= 127L && value >= -128L) {
                result = Byte.valueOf(String.valueOf(value));
            } else if (value <= 32767L && value >= -32768L) {
                result = Short.valueOf(String.valueOf(value));
            } else if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                result = Integer.valueOf(String.valueOf(value));
            }
        }
        return result;
    }

    public static boolean isFloatingPointType(Object left, Object right) {
        return left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double;
    }

    public static boolean isFloatingPointNumber(Object val) {
        if (val instanceof Float || val instanceof Double) {
            return true;
        }
        if (val instanceof String) {
            String string = (String)val;
            return string.indexOf(46) != -1 || string.indexOf(101) != -1 || string.indexOf(69) != -1;
        }
        return false;
    }

    public static boolean isFloatingPoint(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    public static boolean isNumberable(Object o) {
        return o instanceof Integer || o instanceof Long || o instanceof Byte || o instanceof Short;
    }

    public static Number narrowBigInteger(Object lhs, Object rhs, BigInteger bigi) {
        if (!(lhs instanceof BigInteger) && !(rhs instanceof BigInteger) && bigi.compareTo(BIGI_LONG_MAX_VALUE) <= 0 && bigi.compareTo(BIGI_LONG_MIN_VALUE) >= 0) {
            long l = bigi.longValue();
            if (!(lhs instanceof Long) && !(rhs instanceof Long) && l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return Integer.valueOf(String.valueOf(l));
            }
            return Long.valueOf(String.valueOf(l));
        }
        return bigi;
    }

    public static boolean narrowArguments(Object[] args) {
        boolean narrowed = false;
        int a = 0;
        while (a < args.length) {
            Object arg = args[a];
            if (arg instanceof Number) {
                Number narg = NumberUtil.narrow((Number)arg);
                if (narg != arg) {
                    narrowed = true;
                }
                args[a] = narg;
            }
            ++a;
        }
        return narrowed;
    }

    public static Object parseNumber(long l) {
        int i = (int)l;
        if ((long)i == l) {
            return new Integer(i);
        }
        return new Long(l);
    }

    public static Object parseNumber(double d) {
        long f = (long)d;
        if ((double)f == d) {
            return NumberUtil.parseNumber(f);
        }
        return new Double(d);
    }

    public static Object parseNumber(String str) {
        if (str != null) {
            String trimValue = str.trim();
            try {
                return NumberUtil.parseNumber(Double.parseDouble(trimValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static double toDouble(Number number) {
        if (number instanceof Float) {
            return Double.parseDouble(number.toString());
        }
        return number.doubleValue();
    }

    public static <T extends Comparable<T>> int compare(T a, T b) {
        if (a != null && b != null) {
            return a.compareTo(b);
        }
        return a == null ? -1 : 1;
    }

    public static Object calArray(Object obj) {
        if (!(obj instanceof Object[])) {
            return obj;
        }
        Object result = new Integer(0);
        if (!ArrayUtils.isEmpty((Object[])obj)) {
            int i = 0;
            while (i < ((Object[])obj).length) {
                result = Add.add(result, ((Object[])obj)[i]);
                ++i;
            }
        }
        return result;
    }

    public static Class<?> arithmeticClass(Class<?> left, Class<?> right) {
        if (NumberUtil.isDoubleClass(left) || NumberUtil.isDoubleClass(right)) {
            return Double.TYPE;
        }
        if (NumberUtil.isLongClass(left) || NumberUtil.isLongClass(right)) {
            return Long.TYPE;
        }
        return Integer.TYPE;
    }

    public static boolean isDoubleClass(Class<?> type) {
        return type == Double.class || type == Double.TYPE;
    }

    public static boolean isLongClass(Class<?> type) {
        return type == Long.class || type == Long.TYPE;
    }
}

