/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.reactive;

import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaServiceInstance;
import org.springframework.core.Ordered;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class EurekaReactiveDiscoveryClient
implements ReactiveDiscoveryClient {
    private final EurekaClient eurekaClient;
    private final EurekaClientConfig clientConfig;

    public EurekaReactiveDiscoveryClient(EurekaClient eurekaClient, EurekaClientConfig clientConfig) {
        this.eurekaClient = eurekaClient;
        this.clientConfig = clientConfig;
    }

    public String description() {
        return "Spring Cloud Eureka Reactive Discovery Client";
    }

    public Flux<ServiceInstance> getInstances(String serviceId) {
        return Flux.defer(() -> Flux.fromIterable((Iterable)this.eurekaClient.getInstancesByVipAddress(serviceId, false))).map(EurekaServiceInstance::new);
    }

    public Flux<String> getServices() {
        return Flux.defer(() -> Mono.justOrEmpty((Object)this.eurekaClient.getApplications())).flatMapIterable(Applications::getRegisteredApplications).filter(application -> !application.getInstances().isEmpty()).map(Application::getName).map(String::toLowerCase);
    }

    public int getOrder() {
        return this.clientConfig instanceof Ordered ? ((Ordered)this.clientConfig).getOrder() : 0;
    }
}

