package com.codingapi.netfilx.feign.advice;

import com.codingapi.netflix.framework.Constants;
import com.codingapi.netflix.framework.exception.ServerFeignException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author lorne
 * @date 2018/4/19
 * @description
 */
@ControllerAdvice
public class NetflixGlobalExceptionHandler {

    private final static Logger logger = LoggerFactory.getLogger(NetflixGlobalExceptionHandler.class);

    @ExceptionHandler(value = Exception.class)
    public void  serverFeignExceptionHandler(HttpServletRequest request, HttpServletResponse response,
                                   Object handler, Exception e) throws Throwable {

        logger.error("serverFeignExceptionHandler=> handler->"+handler,e);
        String msg =  e.getMessage();
        if(e instanceof ServerFeignException){
            response.addHeader(Constants.GLOBAL_EXCEPTION_HEADER_DEF_FLAG,Constants.GLOBAL_EXCEPTION_HEADER_DEF_FLAG);
        }
        if(e instanceof HystrixRuntimeException) {
            HystrixRuntimeException hystrixRuntimeException = (HystrixRuntimeException) e;
            Throwable throwable = hystrixRuntimeException.getFallbackException();
            if (throwable != null) {
                if (throwable.getCause() != null && throwable.getCause().getCause() instanceof ServerFeignException) {
                    ServerFeignException serverFeignException = (ServerFeignException) throwable.getCause().getCause();
                    msg = serverFeignException.getMessage();
                    response.addHeader(Constants.GLOBAL_EXCEPTION_HEADER_DEF_FLAG, Constants.GLOBAL_EXCEPTION_HEADER_DEF_FLAG);
                }
            }
        }
        if(msg ==null){
            msg = e.getClass().getName();
            response.addHeader(Constants.GLOBAL_EXCEPTION_HEADER_DEF_FLAG,Constants.GLOBAL_EXCEPTION_HEADER_DEF_FLAG);
        }
        response.addHeader(Constants.GLOBAL_EXCEPTION_HEADER,Base64Utils.encodeToString(msg.getBytes()));
        throw e;
    }

}
