package com.codingapi.netfilx.feign.decoder;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.netflix.framework.Constants;
import com.codingapi.netflix.framework.error.FeignError;
import com.codingapi.netflix.framework.exception.ServerFeignException;
import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;
import org.apache.commons.lang.StringUtils;
import org.springframework.context.annotation.Configuration;

/**
 * @author lorne
 * @date 2018/4/19
 * @description
 */
@Configuration
public class FeignErrorDecoder implements ErrorDecoder {

    @Override
    public Exception decode(String methodKey, Response response) {
        if(response.status() >= 400 && response.status() <= 500){
            try {
                String json = Util.toString(response.body().asReader());
                if(StringUtils.isEmpty(json)){
                    return new ServerFeignException(Constants.GLOBAL_EXCEPTION_DEFAULT_CODE,"response body is empty.");
                }
                FeignError feignError =  JSONObject.parseObject(json, FeignError.class);
                if(feignError!=null&&ServerFeignException.class.getName().equals(feignError.getException())) {
                    JSONObject jsonObject = JSONObject.parseObject(feignError.getMessage());
                    return new ServerFeignException(jsonObject.getInteger("code"),jsonObject.getString("msg"));
                }
                return new ServerFeignException(Constants.GLOBAL_EXCEPTION_DEFAULT_CODE,"get feignError fail.");
            } catch (Exception e) {
                return new ServerFeignException(Constants.GLOBAL_EXCEPTION_DEFAULT_CODE,"json parseObject error. ");
            }
        }
        return feign.FeignException.errorStatus(methodKey, response);
    }
}
