package com.codingapi.netflix.framework.exception;

import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lorne
 * @date 2018/4/19
 * @description
 */
public class ServerFeignException extends Exception {


    private int code;

    public int getCode() {
        return code;
    }

    public ServerFeignException(int code, String message) {
        super(toJsonString(code,message));
        this.code = code;
    }

    private static String toJsonString(int code,String message){
        Map<String,String> map = new HashMap<>(2);
        map.put("code",String.valueOf(code));
        map.put("msg",message);
        return JSON.toJSONString(map);
    }

}
