package com.codingapi.netflix.framework.res;

import com.alibaba.fastjson.JSONObject;
import com.codingapi.netflix.framework.res.em.ServerStateEnum;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lorne
 * @date 2018/4/19
 * @description codingapi 数据返回对象.
 */
public class Response implements Serializable {

    /**
     * 服务器状态
     */
    private ServerStateEnum state;

    private String msg;

    private ServerData data;

    public ServerStateEnum getState() {
        return state;
    }

    public void setState(ServerStateEnum state) {
        this.state = state;
    }

    public String getMsg() {
        if(msg==null){
            return "";
        }
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public ServerData getData() {
        return data;
    }

    public void setData(ServerData data) {
        this.data = data;
    }

    public String toJsonString(){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state",state.getCode());
        jsonObject.put("msg",getMsg());
        jsonObject.put("data",getData());
        return jsonObject.toJSONString();
    }

    public Map<String,Object> toMap(){
        Map<String,Object> map = new HashMap<>();
        map.put("state",state.getCode());
        map.put("msg",getMsg());
        map.put("data",getData());
        return map;
    }

}
