package com.codingapi.netflix.framework.res.em;

/**
 * @author lorne
 * @date 2018/4/19
 * @description
 */
public enum ServerStateEnum {

    success(1),error(0);

    private int state;


    ServerStateEnum(int state) {
        this.state = state;
    }

    public static ServerStateEnum valueOfCode(int code) {
        ServerStateEnum[] states = ServerStateEnum.values();
        for (ServerStateEnum type : states) {
            if (type.getCode() == code) {
                return type;
            }
        }
        return null;
    }



    public int getCode() {
        return this.state;
    }

    @Override
    public String toString() {
        return String.valueOf(this.state);
    }

}
