package com.codingapi.sds.delivery.controller;

import com.codingapi.sds.delivery.model.SocketDeliveryParam;
import com.codingapi.sds.delivery.service.OnlineService;
import com.ysscale.socket.vo.DeviceCheck;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * create by lorne on 2017/12/6
 */
@RestController
@RequestMapping("/online")
public class OnlineController {

    @Autowired
    private OnlineService onlineService;

    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public boolean add(@RequestParam("modelName") String modelName, @RequestParam("uniqueKey") String uniqueKey) {
        return onlineService.add(modelName, uniqueKey);
    }


    @RequestMapping(value = "/remove", method = RequestMethod.POST)
    public boolean remove(@RequestParam("modelName") String modelName, @RequestParam("uniqueKey") String uniqueKey) {
        return onlineService.remove(modelName, uniqueKey);
    }

    @RequestMapping(value = "/check", method = RequestMethod.POST)
    public boolean check(@RequestParam("key") String key) {
        return onlineService.check(key);
    }

    @RequestMapping(value = "/checks", method = RequestMethod.POST)
    public List<DeviceCheck> checks(@RequestParam("keys") String keys) {
        return onlineService.checks(keys);
    }


    @RequestMapping(value = "/putKey", method = RequestMethod.POST)
    public boolean putKey(@RequestParam("modelName") String modelName, @RequestParam("uniqueKey") String uniqueKey, @RequestParam("key") String key) {
        return onlineService.putKey(modelName, uniqueKey, key);
    }

    @RequestMapping(value = "/register", method = RequestMethod.POST)
    public boolean register(@RequestParam("serverId") String serverId) {
        return onlineService.register(serverId);
    }

    @RequestMapping(value = "/addSocketUpper", method = RequestMethod.POST)
    public boolean addSocketUpper(@RequestBody SocketDeliveryParam socketDeliveryParam) {
        return onlineService.addSocketUpper(socketDeliveryParam);
    }

    @GetMapping(value = "/delSocketUpper/{serverId}")
    public boolean delSocketUpper(@PathVariable("serverId") String serverId) {
        return onlineService.delSocketUpper(serverId);
    }

    @GetMapping(value = "/getSocketUpper")
    public List getSocketUpper() {
        return onlineService.getSocketUpper();
    }
}
